/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.QueueConfigurations;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueStatistics;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationReportPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.QueueConfigurationsPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.QueueStatisticsPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class QueueInfoPBImpl
extends QueueInfo {
    YarnProtos.QueueInfoProto proto = YarnProtos.QueueInfoProto.getDefaultInstance();
    YarnProtos.QueueInfoProto.Builder builder = null;
    boolean viaProto = false;
    List<ApplicationReport> applicationsList;
    List<QueueInfo> childQueuesList;
    Set<String> accessibleNodeLabels;
    Map<String, QueueConfigurations> queueConfigurations;

    public QueueInfoPBImpl() {
        this.builder = YarnProtos.QueueInfoProto.newBuilder();
    }

    public QueueInfoPBImpl(YarnProtos.QueueInfoProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public List<ApplicationReport> getApplications() {
        this.initLocalApplicationsList();
        return this.applicationsList;
    }

    public float getCapacity() {
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        return p.hasCapacity() ? p.getCapacity() : -1.0f;
    }

    public List<QueueInfo> getChildQueues() {
        this.initLocalChildQueuesList();
        return this.childQueuesList;
    }

    public float getCurrentCapacity() {
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        return p.hasCurrentCapacity() ? p.getCurrentCapacity() : 0.0f;
    }

    public float getMaximumCapacity() {
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        return p.hasMaximumCapacity() ? p.getMaximumCapacity() : -1.0f;
    }

    public String getQueueName() {
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        return p.hasQueueName() ? p.getQueueName() : null;
    }

    public QueueState getQueueState() {
        YarnProtos.QueueInfoProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasState()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getState());
    }

    public void setApplications(List<ApplicationReport> applications) {
        if (applications == null) {
            this.builder.clearApplications();
        }
        this.applicationsList = applications;
    }

    public void setCapacity(float capacity) {
        this.maybeInitBuilder();
        this.builder.setCapacity(capacity);
    }

    public void setChildQueues(List<QueueInfo> childQueues) {
        if (childQueues == null) {
            this.builder.clearChildQueues();
        }
        this.childQueuesList = childQueues;
    }

    public void setCurrentCapacity(float currentCapacity) {
        this.maybeInitBuilder();
        this.builder.setCurrentCapacity(currentCapacity);
    }

    public void setMaximumCapacity(float maximumCapacity) {
        this.maybeInitBuilder();
        this.builder.setMaximumCapacity(maximumCapacity);
    }

    public void setQueueName(String queueName) {
        this.maybeInitBuilder();
        if (queueName == null) {
            this.builder.clearQueueName();
            return;
        }
        this.builder.setQueueName(queueName);
    }

    public void setQueueState(QueueState queueState) {
        this.maybeInitBuilder();
        if (queueState == null) {
            this.builder.clearState();
            return;
        }
        this.builder.setState(this.convertToProtoFormat(queueState));
    }

    public YarnProtos.QueueInfoProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((QueueInfoPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    private void initLocalApplicationsList() {
        if (this.applicationsList != null) {
            return;
        }
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getApplicationsList();
        this.applicationsList = new ArrayList<ApplicationReport>();
        for (YarnProtos.ApplicationReportProto a : list) {
            this.applicationsList.add(this.convertFromProtoFormat(a));
        }
    }

    private void addApplicationsToProto() {
        this.maybeInitBuilder();
        this.builder.clearApplications();
        if (this.applicationsList == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationReportProto> iterable = new Iterable<YarnProtos.ApplicationReportProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationReportProto> iterator() {
                return new Iterator<YarnProtos.ApplicationReportProto>(){
                    Iterator<ApplicationReport> iter;
                    {
                        this.iter = QueueInfoPBImpl.this.applicationsList.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationReportProto next() {
                        return QueueInfoPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplications((Iterable)iterable);
    }

    private void initLocalChildQueuesList() {
        if (this.childQueuesList != null) {
            return;
        }
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        List list = p.getChildQueuesList();
        this.childQueuesList = new ArrayList<QueueInfo>();
        for (YarnProtos.QueueInfoProto a : list) {
            this.childQueuesList.add(this.convertFromProtoFormat(a));
        }
    }

    private void addChildQueuesInfoToProto() {
        this.maybeInitBuilder();
        this.builder.clearChildQueues();
        if (this.childQueuesList == null) {
            return;
        }
        Iterable<YarnProtos.QueueInfoProto> iterable = new Iterable<YarnProtos.QueueInfoProto>(){

            @Override
            public Iterator<YarnProtos.QueueInfoProto> iterator() {
                return new Iterator<YarnProtos.QueueInfoProto>(){
                    Iterator<QueueInfo> iter;
                    {
                        this.iter = QueueInfoPBImpl.this.childQueuesList.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.QueueInfoProto next() {
                        return QueueInfoPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllChildQueues((Iterable)iterable);
    }

    private void addQueueConfigurations() {
        this.maybeInitBuilder();
        this.builder.clearQueueConfigurationsMap();
        if (this.queueConfigurations == null) {
            return;
        }
        Iterable<YarnProtos.QueueConfigurationsMapProto> values = new Iterable<YarnProtos.QueueConfigurationsMapProto>(){

            @Override
            public Iterator<YarnProtos.QueueConfigurationsMapProto> iterator() {
                return new Iterator<YarnProtos.QueueConfigurationsMapProto>(){
                    private Iterator<String> iterator;
                    {
                        this.iterator = QueueInfoPBImpl.this.queueConfigurations.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public YarnProtos.QueueConfigurationsMapProto next() {
                        String key = this.iterator.next();
                        return YarnProtos.QueueConfigurationsMapProto.newBuilder().setPartitionName(key).setQueueConfigurations(QueueInfoPBImpl.this.convertToProtoFormat(QueueInfoPBImpl.this.queueConfigurations.get(key))).build();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllQueueConfigurationsMap((Iterable)values);
    }

    private void mergeLocalToBuilder() {
        if (this.childQueuesList != null) {
            this.addChildQueuesInfoToProto();
        }
        if (this.applicationsList != null) {
            this.addApplicationsToProto();
        }
        if (this.accessibleNodeLabels != null) {
            this.builder.clearAccessibleNodeLabels();
            this.builder.addAllAccessibleNodeLabels(this.accessibleNodeLabels);
        }
        if (this.queueConfigurations != null) {
            this.addQueueConfigurations();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.QueueInfoProto.newBuilder((YarnProtos.QueueInfoProto)this.proto);
        }
        this.viaProto = false;
    }

    private ApplicationReportPBImpl convertFromProtoFormat(YarnProtos.ApplicationReportProto a) {
        return new ApplicationReportPBImpl(a);
    }

    private YarnProtos.ApplicationReportProto convertToProtoFormat(ApplicationReport t) {
        return ((ApplicationReportPBImpl)t).getProto();
    }

    private QueueInfoPBImpl convertFromProtoFormat(YarnProtos.QueueInfoProto a) {
        return new QueueInfoPBImpl(a);
    }

    private YarnProtos.QueueInfoProto convertToProtoFormat(QueueInfo q) {
        return ((QueueInfoPBImpl)q).getProto();
    }

    private QueueState convertFromProtoFormat(YarnProtos.QueueStateProto q) {
        return ProtoUtils.convertFromProtoFormat(q);
    }

    private YarnProtos.QueueStateProto convertToProtoFormat(QueueState queueState) {
        return ProtoUtils.convertToProtoFormat(queueState);
    }

    private QueueConfigurationsPBImpl convertFromProtoFormat(YarnProtos.QueueConfigurationsProto q) {
        return new QueueConfigurationsPBImpl(q);
    }

    private YarnProtos.QueueConfigurationsProto convertToProtoFormat(QueueConfigurations q) {
        return ((QueueConfigurationsPBImpl)q).getProto();
    }

    public void setAccessibleNodeLabels(Set<String> nodeLabels) {
        this.maybeInitBuilder();
        this.builder.clearAccessibleNodeLabels();
        this.accessibleNodeLabels = nodeLabels;
    }

    private void initNodeLabels() {
        if (this.accessibleNodeLabels != null) {
            return;
        }
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        this.accessibleNodeLabels = new HashSet<String>();
        this.accessibleNodeLabels.addAll(p.getAccessibleNodeLabelsList());
    }

    public Set<String> getAccessibleNodeLabels() {
        this.initNodeLabels();
        return this.accessibleNodeLabels;
    }

    public String getDefaultNodeLabelExpression() {
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        return p.hasDefaultNodeLabelExpression() ? p.getDefaultNodeLabelExpression().trim() : null;
    }

    public void setDefaultNodeLabelExpression(String defaultNodeLabelExpression) {
        this.maybeInitBuilder();
        if (defaultNodeLabelExpression == null) {
            this.builder.clearDefaultNodeLabelExpression();
            return;
        }
        this.builder.setDefaultNodeLabelExpression(defaultNodeLabelExpression);
    }

    public String getQueueLabel() {
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        return p.hasQueueLabel() ? p.getQueueLabel() : null;
    }

    public void setQueueLabel(String queueLabel) {
        this.maybeInitBuilder();
        if (queueLabel == null) {
            this.builder.clearQueueLabel();
            return;
        }
        this.builder.setQueueLabel(queueLabel);
    }

    private QueueStatistics convertFromProtoFormat(YarnProtos.QueueStatisticsProto q) {
        return new QueueStatisticsPBImpl(q);
    }

    private YarnProtos.QueueStatisticsProto convertToProtoFormat(QueueStatistics q) {
        return ((QueueStatisticsPBImpl)q).getProto();
    }

    public QueueStatistics getQueueStatistics() {
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        return p.hasQueueStatistics() ? this.convertFromProtoFormat(p.getQueueStatistics()) : null;
    }

    public void setQueueStatistics(QueueStatistics queueStatistics) {
        this.maybeInitBuilder();
        if (queueStatistics == null) {
            this.builder.clearQueueStatistics();
            return;
        }
        this.builder.setQueueStatistics(this.convertToProtoFormat(queueStatistics));
    }

    public Boolean getPreemptionDisabled() {
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        return p.hasPreemptionDisabled() ? Boolean.valueOf(p.getPreemptionDisabled()) : null;
    }

    public void setPreemptionDisabled(boolean preemptionDisabled) {
        this.maybeInitBuilder();
        this.builder.setPreemptionDisabled(preemptionDisabled);
    }

    private void initQueueConfigurations() {
        if (this.queueConfigurations != null) {
            return;
        }
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        List lists = p.getQueueConfigurationsMapList();
        this.queueConfigurations = new HashMap<String, QueueConfigurations>(lists.size());
        for (YarnProtos.QueueConfigurationsMapProto queueConfigurationsProto : lists) {
            this.queueConfigurations.put(queueConfigurationsProto.getPartitionName(), this.convertFromProtoFormat(queueConfigurationsProto.getQueueConfigurations()));
        }
    }

    public Map<String, QueueConfigurations> getQueueConfigurations() {
        this.initQueueConfigurations();
        return this.queueConfigurations;
    }

    public void setQueueConfigurations(Map<String, QueueConfigurations> queueConfigurations) {
        if (queueConfigurations == null) {
            return;
        }
        this.initQueueConfigurations();
        this.queueConfigurations.clear();
        this.queueConfigurations.putAll(queueConfigurations);
    }

    public Boolean getIntraQueuePreemptionDisabled() {
        YarnProtos.QueueInfoProto p = this.viaProto ? this.proto : this.builder;
        return p.hasIntraQueuePreemptionDisabled() ? Boolean.valueOf(p.getIntraQueuePreemptionDisabled()) : null;
    }

    public void setIntraQueuePreemptionDisabled(boolean intraQueuePreemptionDisabled) {
        this.maybeInitBuilder();
        this.builder.setIntraQueuePreemptionDisabled(intraQueuePreemptionDisabled);
    }
}

