/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.objectstorage.model.RenameObjectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class RenameObjectRequest
extends BmcRequest<RenameObjectDetails> {
    private String namespaceName;
    private String bucketName;
    private RenameObjectDetails renameObjectDetails;
    private String opcClientRequestId;

    @InternalSdk
    public RenameObjectDetails getBody$() {
        return this.renameObjectDetails;
    }

    @ConstructorProperties(value={"namespaceName", "bucketName", "renameObjectDetails", "opcClientRequestId"})
    RenameObjectRequest(String namespaceName, String bucketName, RenameObjectDetails renameObjectDetails, String opcClientRequestId) {
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.renameObjectDetails = renameObjectDetails;
        this.opcClientRequestId = opcClientRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).renameObjectDetails(this.renameObjectDetails).opcClientRequestId(this.opcClientRequestId);
    }

    public String toString() {
        return "RenameObjectRequest(super=" + super.toString() + ", namespaceName=" + this.getNamespaceName() + ", bucketName=" + this.getBucketName() + ", renameObjectDetails=" + this.getRenameObjectDetails() + ", opcClientRequestId=" + this.getOpcClientRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenameObjectRequest)) {
            return false;
        }
        RenameObjectRequest other = (RenameObjectRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$namespaceName = this.getNamespaceName();
        String other$namespaceName = other.getNamespaceName();
        if (this$namespaceName == null ? other$namespaceName != null : !this$namespaceName.equals(other$namespaceName)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        RenameObjectDetails this$renameObjectDetails = this.getRenameObjectDetails();
        RenameObjectDetails other$renameObjectDetails = other.getRenameObjectDetails();
        if (this$renameObjectDetails == null ? other$renameObjectDetails != null : !((Object)this$renameObjectDetails).equals(other$renameObjectDetails)) {
            return false;
        }
        String this$opcClientRequestId = this.getOpcClientRequestId();
        String other$opcClientRequestId = other.getOpcClientRequestId();
        return !(this$opcClientRequestId == null ? other$opcClientRequestId != null : !this$opcClientRequestId.equals(other$opcClientRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RenameObjectRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $namespaceName = this.getNamespaceName();
        result = result * 59 + ($namespaceName == null ? 43 : $namespaceName.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        RenameObjectDetails $renameObjectDetails = this.getRenameObjectDetails();
        result = result * 59 + ($renameObjectDetails == null ? 43 : ((Object)$renameObjectDetails).hashCode());
        String $opcClientRequestId = this.getOpcClientRequestId();
        result = result * 59 + ($opcClientRequestId == null ? 43 : $opcClientRequestId.hashCode());
        return result;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public RenameObjectDetails getRenameObjectDetails() {
        return this.renameObjectDetails;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<RenameObjectRequest, RenameObjectDetails> {
        private String namespaceName;
        private String bucketName;
        private RenameObjectDetails renameObjectDetails;
        private String opcClientRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RenameObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.renameObjectDetails(o.getRenameObjectDetails());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RenameObjectRequest build() {
            RenameObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RenameObjectDetails body) {
            this.renameObjectDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder renameObjectDetails(RenameObjectDetails renameObjectDetails) {
            this.renameObjectDetails = renameObjectDetails;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public RenameObjectRequest buildWithoutInvocationCallback() {
            return new RenameObjectRequest(this.namespaceName, this.bucketName, this.renameObjectDetails, this.opcClientRequestId);
        }

        public String toString() {
            return "RenameObjectRequest.Builder(namespaceName=" + this.namespaceName + ", bucketName=" + this.bucketName + ", renameObjectDetails=" + this.renameObjectDetails + ", opcClientRequestId=" + this.opcClientRequestId + ")";
        }
    }
}

