/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class SqlCreateFunction
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final SqlNode className;
    private final SqlNodeList usingList;
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE FUNCTION", SqlKind.CREATE_FUNCTION);

    public SqlCreateFunction(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNode className, SqlNodeList usingList) {
        super((SqlOperator)OPERATOR, pos, replace, ifNotExists);
        this.name = Objects.requireNonNull(name);
        this.className = className;
        this.usingList = Objects.requireNonNull(usingList);
        Preconditions.checkArgument((usingList.size() % 2 == 0 ? 1 : 0) != 0);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getReplace() ? "CREATE OR REPLACE" : "CREATE");
        writer.keyword("FUNCTION");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, 0, 0);
        writer.keyword("AS");
        this.className.unparse(writer, 0, 0);
        if (this.usingList.size() > 0) {
            writer.keyword("USING");
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
            for (Pair<SqlLiteral, SqlLiteral> using : this.pairs()) {
                writer.sep(",");
                ((SqlLiteral)using.left).unparse(writer, 0, 0);
                ((SqlLiteral)using.right).unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
    }

    public void execute(CalcitePrepare.Context context) {
        throw new UnsupportedOperationException("CREATE FUNCTION is not supported yet.");
    }

    private List<Pair<SqlLiteral, SqlLiteral>> pairs() {
        return Util.pairs((List)this.usingList.getList());
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.name, this.className, this.usingList);
    }
}

