/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mockit.Expectations;
import mockit.Tested;
import mockit.internal.expectations.mocking.CaptureOfNewInstances;
import mockit.internal.expectations.mocking.FieldTypeRedefinition;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TypeRedefinitions;
import mockit.internal.reflection.FieldReflection;
import mockit.internal.state.TestRun;
import mockit.internal.util.StackTrace;

public final class FieldTypeRedefinitions
extends TypeRedefinitions {
    private static final int FIELD_ACCESS_MASK = 4104;
    @Nonnull
    private final Map<MockedType, InstanceFactory> mockInstanceFactories = new HashMap<MockedType, InstanceFactory>();
    @Nonnull
    private final List<MockedType> mockFieldsNotSet = new ArrayList<MockedType>();

    public FieldTypeRedefinitions(@Nonnull Class<?> testClass) {
        TestRun.enterNoMockingZone();
        try {
            this.redefineFieldTypes(testClass);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    private void redefineFieldTypes(@Nonnull Class<?> classWithMockFields) {
        Field[] fields;
        Class<?> superClass = classWithMockFields.getSuperclass();
        if (superClass != null && superClass != Object.class && superClass != Expectations.class) {
            this.redefineFieldTypes(superClass);
        }
        for (Field candidateField : fields = classWithMockFields.getDeclaredFields()) {
            int fieldModifiers = candidateField.getModifiers();
            if ((fieldModifiers & 0x1008) != 0) continue;
            this.redefineFieldType(candidateField, fieldModifiers);
        }
    }

    private void redefineFieldType(@Nonnull Field field, int modifiers) {
        MockedType mockedType = new MockedType(field);
        if (mockedType.isMockableType()) {
            boolean partialMocking = field.isAnnotationPresent(Tested.class);
            boolean needsValueToSet = !Modifier.isFinal(modifiers) && !partialMocking;
            this.redefineFieldType(mockedType, partialMocking, needsValueToSet);
            if (!partialMocking) {
                this.registerCaptureOfNewInstances(mockedType);
            }
        }
    }

    private void redefineFieldType(@Nonnull MockedType mockedType, boolean partialMocking, boolean needsValueToSet) {
        boolean redefined;
        FieldTypeRedefinition typeRedefinition = new FieldTypeRedefinition(mockedType);
        if (needsValueToSet) {
            InstanceFactory factory = typeRedefinition.redefineType();
            boolean bl = redefined = factory != null;
            if (redefined) {
                this.mockInstanceFactories.put(mockedType, factory);
            }
        } else {
            redefined = partialMocking ? typeRedefinition.redefineTypeForTestedField() : typeRedefinition.redefineTypeForFinalField();
            if (redefined) {
                this.mockFieldsNotSet.add(mockedType);
            }
        }
        if (redefined) {
            this.addTargetClass(mockedType);
        }
    }

    private void registerCaptureOfNewInstances(@Nonnull MockedType mockedType) {
        if (mockedType.withInstancesToCapture()) {
            if (this.captureOfNewInstances == null) {
                this.captureOfNewInstances = new CaptureOfNewInstances();
            }
            this.captureOfNewInstances.registerCaptureOfNewInstances(mockedType);
        }
    }

    public void assignNewInstancesToMockFields(@Nonnull Object target) {
        TestRun.getExecutingTest().clearRegularAndInjectableMocks();
        this.createAndAssignNewInstances(target);
        this.obtainAndRegisterInstancesOfFieldsNotSet(target);
    }

    private void createAndAssignNewInstances(@Nonnull Object target) {
        for (Map.Entry<MockedType, InstanceFactory> metadataAndFactory : this.mockInstanceFactories.entrySet()) {
            MockedType mockedType = metadataAndFactory.getKey();
            InstanceFactory instanceFactory = metadataAndFactory.getValue();
            Object mock = FieldTypeRedefinitions.assignNewInstanceToMockField(target, mockedType, instanceFactory);
            FieldTypeRedefinitions.registerMock(mockedType, mock);
        }
    }

    @Nonnull
    private static Object assignNewInstanceToMockField(@Nonnull Object target, @Nonnull MockedType mockedType, @Nonnull InstanceFactory instanceFactory) {
        Field mockField = mockedType.field;
        assert (mockField != null);
        Object mock = FieldReflection.getFieldValue(mockField, target);
        if (mock == null) {
            try {
                mock = instanceFactory.create();
            }
            catch (ExceptionInInitializerError | NoClassDefFoundError e) {
                StackTrace.filterStackTrace(e);
                e.printStackTrace();
                throw e;
            }
            FieldReflection.setFieldValue(mockField, target, mock);
        }
        return mock;
    }

    private void obtainAndRegisterInstancesOfFieldsNotSet(@Nonnull Object target) {
        for (MockedType metadata : this.mockFieldsNotSet) {
            assert (metadata.field != null);
            Object mock = FieldReflection.getFieldValue(metadata.field, target);
            if (mock == null) continue;
            FieldTypeRedefinitions.registerMock(metadata, mock);
        }
    }

    public boolean captureNewInstanceForApplicableMockField(@Nonnull Object mock) {
        return this.captureOfNewInstances != null && this.captureOfNewInstances.captureNewInstance(mock);
    }

    @Override
    public void cleanUp() {
        TestRun.getExecutingTest().getCascadingTypes().clear();
        super.cleanUp();
    }
}

