/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.data;

import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.TestRun;
import mockit.coverage.dataItems.PerFileDataCoverage;
import mockit.coverage.lines.PerFileLineCoverage;

public final class FileCoverageData
implements Serializable {
    private static final long serialVersionUID = 3508572808457541012L;
    @Nonnull
    private static final PerFileLineCoverage NO_LINE_INFO = new PerFileLineCoverage();
    @Nonnull
    private static final PerFileDataCoverage NO_DATA_INFO = new PerFileDataCoverage();
    @Nonnull
    public PerFileLineCoverage lineCoverageInfo;
    @Nonnull
    public PerFileDataCoverage dataCoverageInfo;
    @Nonnegative
    public final int index;
    @Nullable
    public String kindOfTopLevelType;
    long lastModified;
    private final boolean loadedAfterTestCompletion;

    FileCoverageData(@Nonnegative int index, @Nullable String kindOfTopLevelType) {
        this.index = index;
        this.kindOfTopLevelType = kindOfTopLevelType;
        this.lineCoverageInfo = new PerFileLineCoverage();
        this.dataCoverageInfo = new PerFileDataCoverage();
        this.loadedAfterTestCompletion = TestRun.isTerminated();
    }

    boolean wasLoadedAfterTestCompletion() {
        return this.loadedAfterTestCompletion;
    }

    @Nonnull
    public PerFileLineCoverage getLineCoverageData() {
        return this.lineCoverageInfo;
    }

    @Nonnegative
    public int getTotalItems() {
        return this.lineCoverageInfo.getTotalItems() + this.dataCoverageInfo.getTotalItems();
    }

    @Nonnegative
    public int getCoveredItems() {
        return this.lineCoverageInfo.getCoveredItems() + this.dataCoverageInfo.getCoveredItems();
    }

    public int getCoveragePercentage() {
        int totalItems = this.getTotalItems();
        int coveredItems = this.getCoveredItems();
        return CoveragePercentage.calculate(coveredItems, totalItems);
    }

    void mergeWithDataFromPreviousTestRun(@Nonnull FileCoverageData previousInfo) {
        if (this.lineCoverageInfo == NO_LINE_INFO) {
            this.lineCoverageInfo = previousInfo.lineCoverageInfo;
        } else if (previousInfo.lineCoverageInfo != NO_LINE_INFO) {
            this.lineCoverageInfo.mergeInformation(previousInfo.lineCoverageInfo);
        }
        if (this.dataCoverageInfo == NO_DATA_INFO) {
            this.dataCoverageInfo = previousInfo.dataCoverageInfo;
        } else if (previousInfo.dataCoverageInfo != NO_DATA_INFO) {
            this.dataCoverageInfo.mergeInformation(previousInfo.dataCoverageInfo);
        }
    }
}

