/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.AbstractNode;
import io.jhdf.ObjectHeader;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.NodeType;
import io.jhdf.dataset.DatasetReader;
import io.jhdf.object.datatype.CompoundDataType;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import io.jhdf.object.datatype.VariableLength;
import io.jhdf.object.message.DataLayout;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.object.message.DataSpace;
import io.jhdf.object.message.DataSpaceMessage;
import io.jhdf.object.message.DataTypeMessage;
import io.jhdf.object.message.FillValueMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatasetBase
extends AbstractNode
implements Dataset {
    private static final Logger logger = LoggerFactory.getLogger(DatasetBase.class);
    protected final HdfBackingStorage hdfBackingStorage;
    protected final ObjectHeader oh;
    private final DataType dataType;
    private final DataSpace dataSpace;

    public DatasetBase(HdfBackingStorage hdfBackingStorage, long address, String name, Group parent, ObjectHeader oh) {
        super(hdfBackingStorage, address, name, parent);
        this.hdfBackingStorage = hdfBackingStorage;
        this.oh = oh;
        this.dataType = this.getHeaderMessage(DataTypeMessage.class).getDataType();
        this.dataSpace = this.getHeaderMessage(DataSpaceMessage.class).getDataSpace();
    }

    @Override
    public NodeType getType() {
        return NodeType.DATASET;
    }

    protected void convertToCorrectEndiness(ByteBuffer bb) {
        if (this.dataType instanceof OrderedDataType) {
            ByteOrder order = ((OrderedDataType)((Object)this.dataType)).getByteOrder();
            bb.order(order);
            if (logger.isTraceEnabled()) {
                logger.trace("Set buffer order of '{}' to {}", (Object)this.getPath(), (Object)order);
            }
        } else {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    @Override
    public long getSize() {
        return this.dataSpace.getTotalLength();
    }

    @Override
    public long getSizeInBytes() {
        return this.getSize() * (long)this.dataType.getSize();
    }

    @Override
    public int[] getDimensions() {
        return this.dataSpace.getDimensions();
    }

    @Override
    public long[] getMaxSize() {
        if (this.dataSpace.isMaxSizesPresent()) {
            return this.dataSpace.getMaxSizes();
        }
        return Arrays.stream(this.getDimensions()).asLongStream().toArray();
    }

    @Override
    public DataLayout getDataLayout() {
        return this.getHeaderMessage(DataLayoutMessage.class).getDataLayout();
    }

    @Override
    public Class<?> getJavaType() {
        Class<?> type = this.dataType.getJavaType();
        if (this.isScalar() && type.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(type);
        }
        return type;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Object getData() {
        logger.debug("Getting data for '{}'...", (Object)this.getPath());
        if (this.isEmpty()) {
            return null;
        }
        ByteBuffer bb = this.getDataBuffer();
        DataType type = this.getDataType();
        return DatasetReader.readDataset(type, bb, this.getDimensions(), this.hdfBackingStorage);
    }

    @Override
    public boolean isScalar() {
        return this.getDimensions().length == 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getSizeInBytes() == 0L;
    }

    @Override
    public boolean isCompound() {
        return this.getDataType() instanceof CompoundDataType;
    }

    public abstract ByteBuffer getDataBuffer();

    @Override
    public Object getFillValue() {
        FillValueMessage fillValueMessage = this.getHeaderMessage(FillValueMessage.class);
        if (fillValueMessage.isFillValueDefined()) {
            ByteBuffer bb = fillValueMessage.getFillValue();
            return DatasetReader.readDataset(this.getDataType(), bb, new int[0], this.hdfBackingStorage);
        }
        return null;
    }

    public String toString() {
        return "DatasetBase [path=" + this.getPath() + "]";
    }

    @Override
    public boolean isVariableLength() {
        return this.getDataType() instanceof VariableLength;
    }

    @Override
    public long getStorageInBytes() {
        return this.getSizeInBytes();
    }
}

