/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import org.apache.drill.exec.metrics.CpuGaugeSet;
import org.apache.drill.exec.util.SystemPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DrillMetrics {
    private static final Logger logger = LoggerFactory.getLogger(DrillMetrics.class);
    public static final boolean METRICS_JMX_OUTPUT_ENABLED = SystemPropertyUtil.getBoolean("drill.metrics.jmx.enabled", true);
    public static final boolean METRICS_LOG_OUTPUT_ENABLED = SystemPropertyUtil.getBoolean("drill.metrics.log.enabled", false);
    public static final int METRICS_LOG_OUTPUT_INTERVAL = SystemPropertyUtil.getInt("drill.metrics.log.interval", 60);

    public static synchronized <T extends Metric> void register(String name, T metric) {
        boolean removed = RegistryHolder.REGISTRY.remove(name);
        if (removed) {
            logger.warn("Removing old metric since name matched newly registered metric. Metric name: {}", (Object)name);
        }
        RegistryHolder.REGISTRY.register(name, metric);
    }

    public static MetricRegistry getRegistry() {
        return RegistryHolder.REGISTRY;
    }

    public static void resetMetrics() {
        RegistryHolder.REGISTRY.removeMatching(MetricFilter.ALL);
        RegistryHolder.registerSystemMetrics();
    }

    private DrillMetrics() {
    }

    private static class RegistryHolder {
        private static final MetricRegistry REGISTRY = new MetricRegistry();
        private static final JmxReporter JMX_REPORTER;
        private static final Slf4jReporter LOG_REPORTER;

        private RegistryHolder() {
        }

        private static void registerSystemMetrics() {
            REGISTRY.registerAll((MetricSet)new GarbageCollectorMetricSet());
            REGISTRY.registerAll((MetricSet)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
            REGISTRY.registerAll((MetricSet)new MemoryUsageGaugeSet());
            REGISTRY.registerAll((MetricSet)new ThreadStatesGaugeSet());
            REGISTRY.registerAll((MetricSet)new CpuGaugeSet());
            DrillMetrics.register("fd.usage", new FileDescriptorRatioGauge());
        }

        private static JmxReporter getJmxReporter() {
            if (METRICS_JMX_OUTPUT_ENABLED) {
                JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)REGISTRY).build();
                reporter.start();
                return reporter;
            }
            return null;
        }

        private static Slf4jReporter getLogReporter() {
            if (METRICS_LOG_OUTPUT_ENABLED) {
                Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)REGISTRY).outputTo(logger).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                reporter.start((long)METRICS_LOG_OUTPUT_INTERVAL, TimeUnit.SECONDS);
                return reporter;
            }
            return null;
        }

        static {
            RegistryHolder.registerSystemMetrics();
            JMX_REPORTER = RegistryHolder.getJmxReporter();
            LOG_REPORTER = RegistryHolder.getLogReporter();
        }
    }
}

