/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TupleValue;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.calcite.adapter.cassandra.CassandraSchema;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;

class CassandraEnumerator
implements Enumerator<Object> {
    private Iterator<Row> iterator;
    private Row current;
    private List<RelDataTypeField> fieldTypes;

    CassandraEnumerator(ResultSet results, RelProtoDataType protoRowType) {
        this.iterator = results.iterator();
        this.current = null;
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        this.fieldTypes = ((RelDataType)protoRowType.apply((Object)typeFactory)).getFieldList();
    }

    public Object current() {
        if (this.fieldTypes.size() == 1) {
            return this.currentRowField(0);
        }
        Object[] row = new Object[this.fieldTypes.size()];
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            row[i] = this.currentRowField(i);
        }
        return row;
    }

    private Object currentRowField(int index) {
        Object o = this.current.get(index, CassandraSchema.CODEC_REGISTRY.codecFor(this.current.getColumnDefinitions().getType(index)));
        return this.convertToEnumeratorObject(o);
    }

    private Object convertToEnumeratorObject(Object obj) {
        if (obj instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)obj;
            byte[] bytes = new byte[buf.remaining()];
            buf.get(bytes, 0, bytes.length);
            return new ByteString(bytes);
        }
        if (obj instanceof LocalDate) {
            return ((LocalDate)obj).getMillisSinceEpoch() / 86400000L;
        }
        if (obj instanceof Date) {
            return ((Date)obj).toInstant().toEpochMilli();
        }
        if (obj instanceof LinkedHashSet) {
            return ((LinkedHashSet)obj).toArray();
        }
        if (obj instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)obj;
            int numComponents = tupleValue.getType().getComponentTypes().size();
            return IntStream.range(0, numComponents).mapToObj(i -> tupleValue.get(i, CassandraSchema.CODEC_REGISTRY.codecFor((DataType)tupleValue.getType().getComponentTypes().get(i)))).map(this::convertToEnumeratorObject).toArray();
        }
        return obj;
    }

    public boolean moveNext() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            return true;
        }
        return false;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

