/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.metadata;

import java.util.stream.Stream;

public enum MetadataType {
    NONE(0),
    TABLE(1),
    SEGMENT(2),
    PARTITION(3),
    FILE(4),
    ROW_GROUP(5),
    ALL(Integer.MAX_VALUE),
    VIEW(-1);

    private final int metadataLevel;

    private MetadataType(int metadataLevel) {
        this.metadataLevel = metadataLevel;
    }

    public boolean includes(MetadataType metadataType) {
        return this.metadataLevel >= metadataType.metadataLevel;
    }

    public static MetadataType fromValue(String value) {
        return Stream.of(MetadataType.values()).filter(type -> type.name().equalsIgnoreCase(value)).findAny().orElse(null);
    }
}

