/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.components.tables;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.MetastoreFieldDefinition;
import org.apache.drill.metastore.exceptions.MetastoreException;
import org.apache.drill.metastore.metadata.MetadataType;

public class TableMetadataUnit {
    public static final Schema SCHEMA = Schema.of(TableMetadataUnit.class, Builder.class);
    public static final TableMetadataUnit EMPTY_UNIT = TableMetadataUnit.builder().build();
    @MetastoreFieldDefinition(column=MetastoreColumn.STORAGE_PLUGIN, scopes={MetadataType.ALL})
    private final String storagePlugin;
    @MetastoreFieldDefinition(column=MetastoreColumn.WORKSPACE, scopes={MetadataType.ALL})
    private final String workspace;
    @MetastoreFieldDefinition(column=MetastoreColumn.TABLE_NAME, scopes={MetadataType.ALL})
    private final String tableName;
    @MetastoreFieldDefinition(column=MetastoreColumn.OWNER, scopes={MetadataType.TABLE})
    private final String owner;
    @MetastoreFieldDefinition(column=MetastoreColumn.TABLE_TYPE, scopes={MetadataType.TABLE})
    private final String tableType;
    @MetastoreFieldDefinition(column=MetastoreColumn.METADATA_TYPE, scopes={MetadataType.ALL})
    private final String metadataType;
    @MetastoreFieldDefinition(column=MetastoreColumn.METADATA_KEY, scopes={MetadataType.ALL})
    private final String metadataKey;
    @MetastoreFieldDefinition(column=MetastoreColumn.LOCATION, scopes={MetadataType.TABLE, MetadataType.SEGMENT, MetadataType.FILE, MetadataType.ROW_GROUP})
    private final String location;
    @MetastoreFieldDefinition(column=MetastoreColumn.INTERESTING_COLUMNS, scopes={MetadataType.TABLE})
    private final List<String> interestingColumns;
    @MetastoreFieldDefinition(column=MetastoreColumn.SCHEMA, scopes={MetadataType.ALL})
    private final String schema;
    @MetastoreFieldDefinition(column=MetastoreColumn.COLUMNS_STATISTICS, scopes={MetadataType.ALL})
    private final Map<String, String> columnsStatistics;
    @MetastoreFieldDefinition(column=MetastoreColumn.METADATA_STATISTICS, scopes={MetadataType.ALL})
    private final List<String> metadataStatistics;
    @MetastoreFieldDefinition(column=MetastoreColumn.LAST_MODIFIED_TIME, scopes={MetadataType.ALL})
    private final Long lastModifiedTime;
    @MetastoreFieldDefinition(column=MetastoreColumn.PARTITION_KEYS, scopes={MetadataType.TABLE})
    private final Map<String, String> partitionKeys;
    @MetastoreFieldDefinition(column=MetastoreColumn.ADDITIONAL_METADATA, scopes={MetadataType.ALL})
    private final String additionalMetadata;
    @MetastoreFieldDefinition(column=MetastoreColumn.METADATA_IDENTIFIER, scopes={MetadataType.SEGMENT, MetadataType.FILE, MetadataType.ROW_GROUP, MetadataType.PARTITION})
    private final String metadataIdentifier;
    @MetastoreFieldDefinition(column=MetastoreColumn.COLUMN, scopes={MetadataType.SEGMENT, MetadataType.PARTITION})
    private final String column;
    @MetastoreFieldDefinition(column=MetastoreColumn.LOCATIONS, scopes={MetadataType.SEGMENT, MetadataType.PARTITION})
    private final List<String> locations;
    @MetastoreFieldDefinition(column=MetastoreColumn.PARTITION_VALUES, scopes={MetadataType.SEGMENT, MetadataType.PARTITION})
    private final List<String> partitionValues;
    @MetastoreFieldDefinition(column=MetastoreColumn.PATH, scopes={MetadataType.SEGMENT, MetadataType.FILE, MetadataType.ROW_GROUP})
    private final String path;
    @MetastoreFieldDefinition(column=MetastoreColumn.ROW_GROUP_INDEX, scopes={MetadataType.ROW_GROUP})
    private final Integer rowGroupIndex;
    @MetastoreFieldDefinition(column=MetastoreColumn.HOST_AFFINITY, scopes={MetadataType.ROW_GROUP})
    private final Map<String, Float> hostAffinity;

    private TableMetadataUnit(Builder builder) {
        this.storagePlugin = builder.storagePlugin;
        this.workspace = builder.workspace;
        this.tableName = builder.tableName;
        this.owner = builder.owner;
        this.tableType = builder.tableType;
        this.metadataType = builder.metadataType;
        this.metadataKey = builder.metadataKey;
        this.location = builder.location;
        this.interestingColumns = builder.interestingColumns;
        this.schema = builder.schema;
        this.columnsStatistics = builder.columnsStatistics;
        this.metadataStatistics = builder.metadataStatistics;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.partitionKeys = builder.partitionKeys;
        this.additionalMetadata = builder.additionalMetadata;
        this.metadataIdentifier = builder.metadataIdentifier;
        this.column = builder.column;
        this.locations = builder.locations;
        this.partitionValues = builder.partitionValues;
        this.path = builder.path;
        this.rowGroupIndex = builder.rowGroupIndex;
        this.hostAffinity = builder.hostAffinity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String storagePlugin() {
        return this.storagePlugin;
    }

    public String workspace() {
        return this.workspace;
    }

    public String tableName() {
        return this.tableName;
    }

    public String owner() {
        return this.owner;
    }

    public String tableType() {
        return this.tableType;
    }

    public String metadataType() {
        return this.metadataType;
    }

    public String metadataKey() {
        return this.metadataKey;
    }

    public String location() {
        return this.location;
    }

    public List<String> interestingColumns() {
        return this.interestingColumns;
    }

    public String schema() {
        return this.schema;
    }

    public Map<String, String> columnsStatistics() {
        return this.columnsStatistics;
    }

    public List<String> metadataStatistics() {
        return this.metadataStatistics;
    }

    public Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Map<String, String> partitionKeys() {
        return this.partitionKeys;
    }

    public String additionalMetadata() {
        return this.additionalMetadata;
    }

    public String metadataIdentifier() {
        return this.metadataIdentifier;
    }

    public String column() {
        return this.column;
    }

    public List<String> locations() {
        return this.locations;
    }

    public List<String> partitionValues() {
        return this.partitionValues;
    }

    public String path() {
        return this.path;
    }

    public Integer rowGroupIndex() {
        return this.rowGroupIndex;
    }

    public Map<String, Float> hostAffinity() {
        return this.hostAffinity;
    }

    public Builder toBuilder() {
        return TableMetadataUnit.builder().storagePlugin(this.storagePlugin).workspace(this.workspace).tableName(this.tableName).owner(this.owner).tableType(this.tableType).metadataType(this.metadataType).metadataKey(this.metadataKey).location(this.location).interestingColumns(this.interestingColumns).schema(this.schema).columnsStatistics(this.columnsStatistics).metadataStatistics(this.metadataStatistics).lastModifiedTime(this.lastModifiedTime).partitionKeys(this.partitionKeys).additionalMetadata(this.additionalMetadata).metadataIdentifier(this.metadataIdentifier).column(this.column).locations(this.locations).partitionValues(this.partitionValues).path(this.path).rowGroupIndex(this.rowGroupIndex).hostAffinity(this.hostAffinity);
    }

    public int hashCode() {
        return Objects.hash(this.storagePlugin, this.workspace, this.tableName, this.owner, this.tableType, this.metadataType, this.metadataKey, this.location, this.interestingColumns, this.schema, this.columnsStatistics, this.metadataStatistics, this.lastModifiedTime, this.partitionKeys, this.additionalMetadata, this.metadataIdentifier, this.column, this.locations, this.partitionValues, this.path, this.rowGroupIndex, this.hostAffinity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableMetadataUnit that = (TableMetadataUnit)o;
        return Objects.equals(this.storagePlugin, that.storagePlugin) && Objects.equals(this.workspace, that.workspace) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.owner, that.owner) && Objects.equals(this.tableType, that.tableType) && Objects.equals(this.metadataType, that.metadataType) && Objects.equals(this.metadataKey, that.metadataKey) && Objects.equals(this.location, that.location) && Objects.equals(this.interestingColumns, that.interestingColumns) && Objects.equals(this.schema, that.schema) && Objects.equals(this.columnsStatistics, that.columnsStatistics) && Objects.equals(this.metadataStatistics, that.metadataStatistics) && Objects.equals(this.lastModifiedTime, that.lastModifiedTime) && Objects.equals(this.partitionKeys, that.partitionKeys) && Objects.equals(this.additionalMetadata, that.additionalMetadata) && Objects.equals(this.metadataIdentifier, that.metadataIdentifier) && Objects.equals(this.column, that.column) && Objects.equals(this.locations, that.locations) && Objects.equals(this.partitionValues, that.partitionValues) && Objects.equals(this.path, that.path) && Objects.equals(this.rowGroupIndex, that.rowGroupIndex) && Objects.equals(this.hostAffinity, that.hostAffinity);
    }

    public String toString() {
        return new StringJoiner(",\n", TableMetadataUnit.class.getSimpleName() + "[", "]").add("storagePlugin=" + this.storagePlugin).add("workspace=" + this.workspace).add("tableName=" + this.tableName).add("owner=" + this.owner).add("tableType=" + this.tableType).add("metadataType=" + this.metadataType).add("metadataKey=" + this.metadataKey).add("location=" + this.location).add("interestingColumns=" + this.interestingColumns).add("schema=" + this.schema).add("columnsStatistics=" + this.columnsStatistics).add("metadataStatistics=" + this.metadataStatistics).add("lastModifiedTime=" + this.lastModifiedTime).add("partitionKeys=" + this.partitionKeys).add("additionalMetadata=" + this.additionalMetadata).add("metadataIdentifier=" + this.metadataIdentifier).add("column=" + this.column).add("locations=" + this.locations).add("partitionValues=" + this.partitionValues).add("path=" + this.path).add("rowGroupIndex=" + this.rowGroupIndex).add("hostAffinity=" + this.hostAffinity).toString();
    }

    public static class Schema {
        private final List<MetastoreColumn> tableColumns;
        private final List<MetastoreColumn> segmentColumns;
        private final List<MetastoreColumn> fileColumns;
        private final List<MetastoreColumn> rowGroupColumns;
        private final List<MetastoreColumn> partitionColumns;
        private final Map<String, MethodHandle> unitGetters;
        private final Map<String, MethodHandle> unitBuilderSetters;

        private Schema(List<MetastoreColumn> tableColumns, List<MetastoreColumn> segmentColumns, List<MetastoreColumn> fileColumns, List<MetastoreColumn> rowGroupColumns, List<MetastoreColumn> partitionColumns, Map<String, MethodHandle> unitGetters, Map<String, MethodHandle> unitBuilderSetters) {
            this.tableColumns = tableColumns;
            this.segmentColumns = segmentColumns;
            this.fileColumns = fileColumns;
            this.rowGroupColumns = rowGroupColumns;
            this.partitionColumns = partitionColumns;
            this.unitGetters = unitGetters;
            this.unitBuilderSetters = unitBuilderSetters;
        }

        public static Schema of(Class<?> unitClass, Class<?> builderClass) {
            ArrayList<MetastoreColumn> tableColumns = new ArrayList<MetastoreColumn>();
            ArrayList<MetastoreColumn> segmentColumns = new ArrayList<MetastoreColumn>();
            ArrayList<MetastoreColumn> fileColumns = new ArrayList<MetastoreColumn>();
            ArrayList<MetastoreColumn> rowGroupColumns = new ArrayList<MetastoreColumn>();
            ArrayList<MetastoreColumn> partitionColumns = new ArrayList<MetastoreColumn>();
            HashMap<String, MethodHandle> unitGetters = new HashMap<String, MethodHandle>();
            HashMap<String, MethodHandle> unitBuilderSetters = new HashMap<String, MethodHandle>();
            MethodHandles.Lookup gettersLookup = MethodHandles.publicLookup().in(unitClass);
            MethodHandles.Lookup settersLookup = MethodHandles.publicLookup().in(builderClass);
            for (Field field : unitClass.getDeclaredFields()) {
                MetastoreFieldDefinition definition = field.getAnnotation(MetastoreFieldDefinition.class);
                if (definition == null) continue;
                MetastoreColumn column = definition.column();
                block11: for (MetadataType scope : definition.scopes()) {
                    switch (scope) {
                        case TABLE: {
                            tableColumns.add(column);
                            continue block11;
                        }
                        case SEGMENT: {
                            segmentColumns.add(column);
                            continue block11;
                        }
                        case FILE: {
                            fileColumns.add(column);
                            continue block11;
                        }
                        case ROW_GROUP: {
                            rowGroupColumns.add(column);
                            continue block11;
                        }
                        case PARTITION: {
                            partitionColumns.add(column);
                            continue block11;
                        }
                        case ALL: {
                            tableColumns.add(column);
                            segmentColumns.add(column);
                            fileColumns.add(column);
                            rowGroupColumns.add(column);
                            partitionColumns.add(column);
                            continue block11;
                        }
                        default: {
                            throw new IllegalStateException(scope.name());
                        }
                    }
                }
                Class<?> type = field.getType();
                try {
                    String fieldName = field.getName();
                    String columnName = column.columnName();
                    MethodHandle getter = gettersLookup.findVirtual(unitClass, fieldName, MethodType.methodType(type));
                    unitGetters.put(columnName, getter);
                    MethodHandle setter = settersLookup.findVirtual(builderClass, fieldName, MethodType.methodType(builderClass, type));
                    unitBuilderSetters.put(columnName, setter);
                }
                catch (ReflectiveOperationException e) {
                    throw new MetastoreException(String.format("Unable to init unit setter / getter method handlers for unit [%s] and its builder [%s] classes", unitClass.getSimpleName(), builderClass.getSimpleName()), e);
                }
            }
            return new Schema(tableColumns, segmentColumns, fileColumns, rowGroupColumns, partitionColumns, unitGetters, unitBuilderSetters);
        }

        public List<MetastoreColumn> tableColumns() {
            return this.tableColumns;
        }

        public List<MetastoreColumn> segmentColumns() {
            return this.segmentColumns;
        }

        public List<MetastoreColumn> fileColumns() {
            return this.fileColumns;
        }

        public List<MetastoreColumn> rowGroupColumns() {
            return this.rowGroupColumns;
        }

        public List<MetastoreColumn> partitionColumns() {
            return this.partitionColumns;
        }

        public Map<String, MethodHandle> unitGetters() {
            return this.unitGetters;
        }

        public Map<String, MethodHandle> unitBuilderSetters() {
            return this.unitBuilderSetters;
        }
    }

    public static class Builder {
        private String storagePlugin;
        private String workspace;
        private String tableName;
        private String owner;
        private String tableType;
        private String metadataType;
        private String metadataKey;
        private String location;
        private List<String> interestingColumns;
        private String schema;
        private Map<String, String> columnsStatistics;
        private List<String> metadataStatistics;
        private Long lastModifiedTime;
        private Map<String, String> partitionKeys;
        private String additionalMetadata;
        private String metadataIdentifier;
        private String column;
        private List<String> locations;
        private List<String> partitionValues;
        private String path;
        private Integer rowGroupIndex;
        private Map<String, Float> hostAffinity;

        public Builder storagePlugin(String storagePlugin) {
            this.storagePlugin = storagePlugin;
            return this;
        }

        public Builder workspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder tableType(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public Builder metadataType(String metadataType) {
            this.metadataType = metadataType;
            return this;
        }

        public Builder metadataKey(String metadataKey) {
            this.metadataKey = metadataKey;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder interestingColumns(List<String> interestingColumns) {
            this.interestingColumns = interestingColumns;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder columnsStatistics(Map<String, String> columnsStatistics) {
            this.columnsStatistics = columnsStatistics;
            return this;
        }

        public Builder metadataStatistics(List<String> metadataStatistics) {
            this.metadataStatistics = metadataStatistics;
            return this;
        }

        public Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public Builder partitionKeys(Map<String, String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public Builder additionalMetadata(String additionalMetadata) {
            this.additionalMetadata = additionalMetadata;
            return this;
        }

        public Builder metadataIdentifier(String metadataIdentifier) {
            this.metadataIdentifier = metadataIdentifier;
            return this;
        }

        public Builder column(String column) {
            this.column = column;
            return this;
        }

        public Builder locations(List<String> locations) {
            this.locations = locations;
            return this;
        }

        public Builder partitionValues(List<String> partitionValues) {
            this.partitionValues = partitionValues;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder rowGroupIndex(Integer rowGroupIndex) {
            this.rowGroupIndex = rowGroupIndex;
            return this;
        }

        public Builder hostAffinity(Map<String, Float> hostAffinity) {
            this.hostAffinity = hostAffinity;
            return this;
        }

        public TableMetadataUnit build() {
            return new TableMetadataUnit(this);
        }
    }
}

