/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.writers.complex;

import org.apache.drill.exec.store.hive.writers.HiveValueWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class HiveStructWriter
implements HiveValueWriter {
    private final StructObjectInspector structObjectInspector;
    private final StructField[] structFields;
    private final HiveValueWriter[] fieldWriters;
    private final BaseWriter.MapWriter structWriter;

    public HiveStructWriter(StructObjectInspector structObjectInspector, StructField[] structFields, HiveValueWriter[] fieldWriters, BaseWriter.MapWriter structWriter) {
        this.structObjectInspector = structObjectInspector;
        this.structFields = structFields;
        this.fieldWriters = fieldWriters;
        this.structWriter = structWriter;
    }

    @Override
    public void write(Object value) {
        this.structWriter.start();
        for (int fieldIdx = 0; fieldIdx < this.structFields.length; ++fieldIdx) {
            Object fieldValue = this.structObjectInspector.getStructFieldData(value, this.structFields[fieldIdx]);
            if (fieldValue == null) {
                throw new UnsupportedOperationException("Null is not supported in Hive struct");
            }
            this.fieldWriters[fieldIdx].write(fieldValue);
        }
        this.structWriter.end();
    }
}

