/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(HiveMetadataProvider.class);
    public static final int RECORD_SIZE = 1024;
    private final HiveReadEntry hiveReadEntry;
    private final UserGroupInformation ugi;
    private final boolean isPartitionedTable;
    private final Map<Partition, List<LogicalInputSplit>> partitionInputSplitMap;
    private final HiveConf hiveConf;
    private List<LogicalInputSplit> tableInputSplits;
    private final Stopwatch watch = Stopwatch.createUnstarted();

    public HiveMetadataProvider(String userName, HiveReadEntry hiveReadEntry, HiveConf hiveConf) {
        this.hiveReadEntry = hiveReadEntry;
        this.ugi = ImpersonationUtil.createProxyUgi((String)userName);
        this.isPartitionedTable = hiveReadEntry.getTable().getPartitionKeysSize() > 0;
        this.partitionInputSplitMap = new HashMap<Partition, List<LogicalInputSplit>>();
        this.hiveConf = hiveConf;
    }

    public HiveStats getStats(HiveReadEntry hiveReadEntry) throws IOException {
        HiveStats hiveStats;
        HiveTableWithColumnCache table;
        Stopwatch timeGetStats;
        block8: {
            HiveStats stats;
            block9: {
                timeGetStats = Stopwatch.createStarted();
                table = hiveReadEntry.getTable();
                if (this.isPartitionedTable) break block8;
                Properties properties = new Table((org.apache.hadoop.hive.metastore.api.Table)table).getMetadata();
                stats = HiveStats.getStatsFromProps(properties);
                if (!stats.valid()) break block9;
                HiveStats hiveStats2 = stats;
                logger.debug("Took {} \u00b5s to get stats from {}.{}", new Object[]{timeGetStats.elapsed(TimeUnit.NANOSECONDS) / 1000L, table.getDbName(), table.getTableName()});
                return hiveStats2;
            }
            HiveStats hiveStats3 = stats.getSizeInBytes() > 0L ? this.estimateStatsFromBytes(stats.getSizeInBytes()) : this.estimateStatsFromInputSplits(this.getTableInputSplits());
            logger.debug("Took {} \u00b5s to get stats from {}.{}", new Object[]{timeGetStats.elapsed(TimeUnit.NANOSECONDS) / 1000L, table.getDbName(), table.getTableName()});
            return hiveStats3;
        }
        try {
            HiveStats aggStats = new HiveStats(0L, 0L);
            for (HivePartition partition : hiveReadEntry.getPartitions()) {
                Properties properties = HiveUtilities.getPartitionMetadata(partition, table);
                HiveStats stats = HiveStats.getStatsFromProps(properties);
                if (!stats.valid()) {
                    stats = stats.getSizeInBytes() > 0L ? this.estimateStatsFromBytes(stats.getSizeInBytes()) : this.estimateStatsFromInputSplits(this.getPartitionInputSplits(partition));
                }
                aggStats.add(stats);
            }
            hiveStats = aggStats;
        }
        catch (Exception e) {
            try {
                throw new IOException("Failed to get number of rows and total size from HiveTable", e);
            }
            catch (Throwable throwable) {
                logger.debug("Took {} \u00b5s to get stats from {}.{}", new Object[]{timeGetStats.elapsed(TimeUnit.NANOSECONDS) / 1000L, table.getDbName(), table.getTableName()});
                throw throwable;
            }
        }
        logger.debug("Took {} \u00b5s to get stats from {}.{}", new Object[]{timeGetStats.elapsed(TimeUnit.NANOSECONDS) / 1000L, table.getDbName(), table.getTableName()});
        return hiveStats;
    }

    private List<LogicalInputSplit> getTableInputSplits() {
        Preconditions.checkState((!this.isPartitionedTable ? 1 : 0) != 0, (Object)"Works only for non-partitioned tables");
        if (this.tableInputSplits != null) {
            return this.tableInputSplits;
        }
        Properties properties = HiveUtilities.getTableMetadata(this.hiveReadEntry.getTable());
        this.tableInputSplits = this.splitInputWithUGI(properties, this.hiveReadEntry.getTable().getSd(), null);
        return this.tableInputSplits;
    }

    private List<LogicalInputSplit> getPartitionInputSplits(HivePartition partition) {
        if (this.partitionInputSplitMap.containsKey((Object)partition)) {
            return this.partitionInputSplitMap.get((Object)partition);
        }
        Properties properties = HiveUtilities.getPartitionMetadata(partition, this.hiveReadEntry.getTable());
        List<LogicalInputSplit> splits = this.splitInputWithUGI(properties, partition.getSd(), partition);
        this.partitionInputSplitMap.put(partition, splits);
        return splits;
    }

    public List<LogicalInputSplit> getInputSplits(HiveReadEntry hiveReadEntry) {
        List<LogicalInputSplit> list;
        Stopwatch timeGetSplits;
        block5: {
            timeGetSplits = Stopwatch.createStarted();
            if (this.isPartitionedTable) break block5;
            List<LogicalInputSplit> list2 = this.getTableInputSplits();
            logger.debug("Took {} \u00b5s to get InputSplits from {}.{}", new Object[]{timeGetSplits.elapsed(TimeUnit.NANOSECONDS) / 1000L, hiveReadEntry.getTable().getDbName(), hiveReadEntry.getTable().getTableName()});
            return list2;
        }
        try {
            list = hiveReadEntry.getPartitions().stream().flatMap(p -> this.getPartitionInputSplits((HivePartition)((Object)p)).stream()).collect(Collectors.toList());
        }
        catch (Exception e) {
            try {
                logger.error("Failed to get InputSplits", (Throwable)e);
                throw new DrillRuntimeException("Failed to get InputSplits", (Throwable)e);
            }
            catch (Throwable throwable) {
                logger.debug("Took {} \u00b5s to get InputSplits from {}.{}", new Object[]{timeGetSplits.elapsed(TimeUnit.NANOSECONDS) / 1000L, hiveReadEntry.getTable().getDbName(), hiveReadEntry.getTable().getTableName()});
                throw throwable;
            }
        }
        logger.debug("Took {} \u00b5s to get InputSplits from {}.{}", new Object[]{timeGetSplits.elapsed(TimeUnit.NANOSECONDS) / 1000L, hiveReadEntry.getTable().getDbName(), hiveReadEntry.getTable().getTableName()});
        return list;
    }

    protected List<String> getInputDirectories(HiveReadEntry hiveReadEntry) {
        if (this.isPartitionedTable) {
            return hiveReadEntry.getPartitions().stream().map(p -> p.getSd().getLocation()).collect(Collectors.toList());
        }
        return Collections.singletonList(hiveReadEntry.getTable().getSd().getLocation());
    }

    private HiveStats estimateStatsFromInputSplits(List<LogicalInputSplit> inputSplits) throws IOException {
        logger.trace("Collecting stats based on input splits size. It means that we might have fetched all input splits before applying any possible optimizations (ex: partition pruning). Consider using ANALYZE command on Hive table to collect statistics before running queries.");
        long sizeInBytes = 0L;
        for (LogicalInputSplit split : inputSplits) {
            sizeInBytes += split.getLength();
        }
        return this.estimateStatsFromBytes(sizeInBytes);
    }

    private HiveStats estimateStatsFromBytes(long sizeInBytes) {
        long numRows = sizeInBytes / 1024L;
        numRows = numRows == 0L && sizeInBytes > 0L ? 1L : numRows;
        return new HiveStats(numRows, sizeInBytes);
    }

    private List<LogicalInputSplit> splitInputWithUGI(Properties properties, StorageDescriptor sd, Partition partition) {
        this.watch.start();
        try {
            List list = (List)this.ugi.doAs(() -> {
                ArrayList<LogicalInputSplit> splits;
                block4: {
                    splits = new ArrayList<LogicalInputSplit>();
                    JobConf job = new JobConf((Configuration)this.hiveConf);
                    HiveUtilities.addConfToJob(job, properties);
                    HiveUtilities.verifyAndAddTransactionalProperties(job, sd);
                    job.setInputFormat(HiveUtilities.getInputFormatClass(job, sd, this.hiveReadEntry.getTable()));
                    Path path = new Path(sd.getLocation());
                    FileSystem fs = path.getFileSystem((Configuration)job);
                    if (!fs.exists(path)) break block4;
                    FileInputFormat.addInputPath((JobConf)job, (Path)path);
                    InputFormat format = job.getInputFormat();
                    InputSplit[] inputSplits = format.getSplits(job, 1);
                    if (TextInputFormat.class.getCanonicalName().equals(sd.getInputFormat()) && HiveUtilities.hasHeaderOrFooter(this.hiveReadEntry.getTable())) {
                        Multimap<Path, FileSplit> inputSplitMultimap = this.transformFileSplits(inputSplits);
                        for (Collection logicalInputSplit : inputSplitMultimap.asMap().values()) {
                            splits.add(new LogicalInputSplit(logicalInputSplit, partition));
                        }
                    } else {
                        for (InputSplit split : inputSplits) {
                            splits.add(new LogicalInputSplit(split, partition));
                        }
                    }
                }
                return splits;
            });
            return list;
        }
        catch (IOException | InterruptedException e) {
            String errMsg = String.format("Failed to create input splits: %s", e.getMessage());
            logger.error(errMsg, (Throwable)e);
            throw new DrillRuntimeException(errMsg, (Throwable)e);
        }
        finally {
            logger.trace("Took {} \u00b5s to get splits from {}", (Object)(this.watch.elapsed(TimeUnit.NANOSECONDS) / 1000L), (Object)sd.getLocation());
            this.watch.stop();
        }
    }

    private Multimap<Path, FileSplit> transformFileSplits(InputSplit[] inputSplits) {
        TreeMultimap inputSplitGroups = TreeMultimap.create((Comparator)Ordering.natural(), Comparator.comparingLong(FileSplit::getStart));
        for (InputSplit inputSplit : inputSplits) {
            FileSplit fileSplit = (FileSplit)inputSplit;
            inputSplitGroups.put((Object)fileSplit.getPath(), (Object)fileSplit);
        }
        return inputSplitGroups;
    }

    public static class HiveStats {
        private static final Logger logger = LoggerFactory.getLogger(HiveStats.class);
        private long numRows;
        private long sizeInBytes;

        public HiveStats(long numRows, long sizeInBytes) {
            this.numRows = numRows;
            this.sizeInBytes = sizeInBytes;
        }

        public static HiveStats getStatsFromProps(Properties properties) {
            long numRows = -1L;
            long sizeInBytes = -1L;
            try {
                String numRowsProp;
                String sizeInBytesProp = properties.getProperty("totalSize");
                if (sizeInBytesProp != null) {
                    sizeInBytes = Long.valueOf(sizeInBytesProp);
                }
                if ((numRowsProp = properties.getProperty("numRows")) != null) {
                    numRows = Long.valueOf(numRowsProp);
                }
            }
            catch (NumberFormatException e) {
                logger.error("Failed to parse Hive stats from metastore.", (Throwable)e);
            }
            HiveStats hiveStats = new HiveStats(numRows, sizeInBytes);
            logger.trace("Obtained Hive stats from properties: {}.", (Object)hiveStats);
            return hiveStats;
        }

        public long getNumRows() {
            return this.numRows;
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public boolean valid() {
            return this.numRows > 0L && this.sizeInBytes > 0L;
        }

        public void add(HiveStats s) {
            this.numRows += s.numRows;
            this.sizeInBytes += s.sizeInBytes;
        }

        public String toString() {
            return "numRows: " + this.numRows + ", sizeInBytes: " + this.sizeInBytes;
        }
    }

    public static class LogicalInputSplit {
        private final Collection<InputSplit> inputSplits = new ArrayList<InputSplit>();
        private final Partition partition;

        public LogicalInputSplit(InputSplit inputSplit, Partition partition) {
            this.inputSplits.add(inputSplit);
            this.partition = partition;
        }

        public LogicalInputSplit(Collection<? extends InputSplit> inputSplits, Partition partition) {
            this.inputSplits.addAll(inputSplits);
            this.partition = partition;
        }

        public Collection<InputSplit> getInputSplits() {
            return this.inputSplits;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public long getLength() throws IOException {
            long length = 0L;
            for (InputSplit inputSplit : this.inputSplits) {
                length += inputSplit.getLength();
            }
            return length;
        }

        public Collection<String> getLocations() throws IOException {
            HashSet<String> locations = new HashSet<String>();
            for (InputSplit inputSplit : this.inputSplits) {
                Collections.addAll(locations, inputSplit.getLocations());
            }
            return locations;
        }

        public List<String> serialize() throws IOException {
            ArrayList<String> serializedInputSplits = new ArrayList<String>();
            for (InputSplit inputSplit : this.inputSplits) {
                ByteArrayDataOutput byteArrayOutputStream = ByteStreams.newDataOutput();
                inputSplit.write((DataOutput)byteArrayOutputStream);
                String encoded = Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray());
                logger.debug("Encoded split string for split {} : {}", (Object)inputSplit, (Object)encoded);
                serializedInputSplits.add(encoded);
            }
            return serializedInputSplits;
        }

        public String getType() {
            if (this.inputSplits.isEmpty()) {
                return null;
            }
            return this.inputSplits.iterator().next().getClass().getName();
        }
    }
}

