/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;

abstract class InvocationResult {
    InvocationResult next;

    InvocationResult() {
    }

    @Nullable
    Object produceResult(@Nonnull Object[] args) throws Throwable {
        return null;
    }

    @Nullable
    Object produceResult(@Nullable Object invokedObject, @Nonnull ExpectedInvocation invocation, @Nonnull InvocationConstraints constraints, @Nonnull Object[] args) throws Throwable {
        return this.produceResult(args);
    }

    static final class DeferredResults
    extends InvocationResult {
        @Nonnull
        private final Iterator<?> values;

        DeferredResults(@Nonnull Iterator<?> values) {
            this.values = values;
        }

        @Override
        @Nullable
        Object produceResult(@Nonnull Object[] args) throws Throwable {
            Object nextValue;
            Object v0 = nextValue = this.values.hasNext() ? this.values.next() : null;
            if (nextValue instanceof Throwable) {
                Throwable t = nextValue;
                t.fillInStackTrace();
                throw t;
            }
            return nextValue;
        }
    }

    static final class ThrowableResult
    extends InvocationResult {
        @Nonnull
        private final Throwable throwable;

        ThrowableResult(@Nonnull Throwable throwable) {
            this.throwable = throwable;
        }

        @Override
        @Nonnull
        Object produceResult(@Nonnull Object[] args) throws Throwable {
            this.throwable.fillInStackTrace();
            throw this.throwable;
        }
    }

    static final class ReturnValueResult
    extends InvocationResult {
        @Nullable
        private final Object returnValue;

        ReturnValueResult(@Nullable Object returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        @Nullable
        Object produceResult(@Nonnull Object[] args) {
            return this.returnValue;
        }
    }
}

