/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.util.Iterator;
import java.util.Map;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.table.Table;

public class UpdateStatement
extends SQLStatement {
    protected SQLExpression[] updates = null;

    public UpdateStatement(RDBMSStoreManager rdbmsMgr, Table table, DatastoreIdentifier alias, String tableGroupName, Map<String, Object> extensions) {
        super(null, rdbmsMgr, table, alias, tableGroupName, extensions);
    }

    public void setUpdates(SQLExpression[] exprs) {
        this.invalidateStatement();
        this.updates = exprs;
    }

    public boolean hasUpdates() {
        if (this.updates == null) {
            return false;
        }
        for (int i = 0; i < this.updates.length; ++i) {
            if (this.updates[i] == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public SQLText getSQLText() {
        if (this.sql != null) {
            return this.sql;
        }
        SQLText setSQL = new SQLText("SET ");
        if (this.updates != null && this.updates.length > 0) {
            for (int i = 0; i < this.updates.length; ++i) {
                if (this.updates[i] == null) continue;
                if (i != 0) {
                    setSQL.append(",");
                }
                setSQL.append(this.updates[i].toSQLText());
            }
        }
        this.sql = this.rdbmsMgr.getDatastoreAdapter().getUpdateTableStatement(this.primaryTable, setSQL);
        if (this.joins != null) {
            Iterator joinIter = this.joins.iterator();
            SQLJoin subJoin = (SQLJoin)joinIter.next();
            SelectStatement subStmt = new SelectStatement(this, this.rdbmsMgr, subJoin.getTargetTable().getTable(), subJoin.getTargetTable().getAlias(), subJoin.getTargetTable().getGroupName());
            ((SQLStatement)subStmt).whereAnd(subJoin.getCondition(), false);
            if (this.where != null) {
                ((SQLStatement)subStmt).whereAnd(this.where, false);
            }
            while (joinIter.hasNext()) {
                SQLJoin join = (SQLJoin)joinIter.next();
                subStmt.joins.add(join);
            }
            BooleanSubqueryExpression existsExpr = new BooleanSubqueryExpression((SQLStatement)this, "EXISTS", subStmt);
            this.where = existsExpr;
        }
        if (this.where != null) {
            this.sql.append(" WHERE ").append(this.where.toSQLText());
        }
        return this.sql;
    }
}

