/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SortExchange;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalSortExchange;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexInputRef;

public class ExchangeRemoveConstantKeysRule
extends RelOptRule {
    public static final ExchangeRemoveConstantKeysRule EXCHANGE_INSTANCE = new ExchangeRemoveConstantKeysRule(LogicalExchange.class, "ExchangeRemoveConstantKeysRule");
    public static final ExchangeRemoveConstantKeysRule SORT_EXCHANGE_INSTANCE = new SortExchangeRemoveConstantKeysRule(LogicalSortExchange.class, "SortExchangeRemoveConstantKeysRule");

    private ExchangeRemoveConstantKeysRule(Class<? extends RelNode> clazz, String description) {
        super(ExchangeRemoveConstantKeysRule.operand(clazz, ExchangeRemoveConstantKeysRule.any()), RelFactories.LOGICAL_BUILDER, description);
    }

    protected static List<Integer> simplifyDistributionKeys(RelDistribution distribution, Set<Integer> constants) {
        return distribution.getKeys().stream().filter(key -> !constants.contains(key)).collect(Collectors.toList());
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Exchange exchange = (Exchange)call.rel(0);
        return exchange.getDistribution().getType() == RelDistribution.Type.HASH_DISTRIBUTED;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode input;
        Exchange exchange = (Exchange)call.rel(0);
        Object mq = call.getMetadataQuery();
        RelOptPredicateList predicates = ((RelMetadataQuery)mq).getPulledUpPredicates(input = exchange.getInput());
        if (predicates == null) {
            return;
        }
        HashSet<Integer> constants = new HashSet<Integer>();
        predicates.constantMap.keySet().forEach(key -> {
            if (key instanceof RexInputRef) {
                constants.add(((RexInputRef)key).getIndex());
            }
        });
        if (constants.isEmpty()) {
            return;
        }
        List<Integer> distributionKeys = ExchangeRemoveConstantKeysRule.simplifyDistributionKeys(exchange.getDistribution(), constants);
        if (distributionKeys.size() != exchange.getDistribution().getKeys().size()) {
            call.transformTo(call.builder().push(exchange.getInput()).exchange(distributionKeys.isEmpty() ? RelDistributions.SINGLETON : RelDistributions.hash(distributionKeys)).build());
            call.getPlanner().setImportance(exchange, 0.0);
        }
    }

    public static class SortExchangeRemoveConstantKeysRule
    extends ExchangeRemoveConstantKeysRule {
        private SortExchangeRemoveConstantKeysRule(Class<? extends RelNode> clazz, String description) {
            super(clazz, description);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            SortExchange sortExchange = (SortExchange)call.rel(0);
            return sortExchange.getDistribution().getType() == RelDistribution.Type.HASH_DISTRIBUTED || !sortExchange.getCollation().getFieldCollations().isEmpty();
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            List<RelFieldCollation> fieldCollations;
            boolean collationSimplified;
            boolean hashDistribution;
            RelNode input;
            SortExchange sortExchange = (SortExchange)call.rel(0);
            Object mq = call.getMetadataQuery();
            RelOptPredicateList predicates = ((RelMetadataQuery)mq).getPulledUpPredicates(input = sortExchange.getInput());
            if (predicates == null) {
                return;
            }
            HashSet<Integer> constants = new HashSet<Integer>();
            predicates.constantMap.keySet().forEach(key -> {
                if (key instanceof RexInputRef) {
                    constants.add(((RexInputRef)key).getIndex());
                }
            });
            if (constants.isEmpty()) {
                return;
            }
            List<Object> distributionKeys = new ArrayList();
            boolean distributionSimplified = false;
            boolean bl = hashDistribution = sortExchange.getDistribution().getType() == RelDistribution.Type.HASH_DISTRIBUTED;
            if (hashDistribution) {
                distributionKeys = SortExchangeRemoveConstantKeysRule.simplifyDistributionKeys(sortExchange.getDistribution(), constants);
                distributionSimplified = distributionKeys.size() != sortExchange.getDistribution().getKeys().size();
            }
            boolean bl2 = collationSimplified = (fieldCollations = sortExchange.getCollation().getFieldCollations().stream().filter(fc -> !constants.contains(fc.getFieldIndex())).collect(Collectors.toList())).size() != sortExchange.getCollation().getFieldCollations().size();
            if (distributionSimplified || collationSimplified) {
                RelDistribution distribution = distributionSimplified ? (distributionKeys.isEmpty() ? RelDistributions.SINGLETON : RelDistributions.hash(distributionKeys)) : sortExchange.getDistribution();
                RelCollation collation = collationSimplified ? RelCollations.of(fieldCollations) : sortExchange.getCollation();
                call.transformTo(call.builder().push(sortExchange.getInput()).sortExchange(distribution, collation).build());
                call.getPlanner().setImportance(sortExchange, 0.0);
            }
        }
    }
}

