/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class FillValueMessage
extends Message {
    private static final int FILL_VALUE_DEFINED_BIT = 5;
    private final int spaceAllocationTime;
    private final int fillValueWriteTime;
    private final boolean fillValueDefined;
    private final ByteBuffer fillValue;

    FillValueMessage(ByteBuffer bb, BitSet messageFlags) {
        super(messageFlags);
        byte version = bb.get();
        if (version == 1 || version == 2) {
            boolean fillValueMaybeDefined;
            this.spaceAllocationTime = bb.get();
            this.fillValueWriteTime = bb.get();
            boolean bl = fillValueMaybeDefined = bb.get() == 1;
            if (version == 2 && fillValueMaybeDefined) {
                int size = Utils.readBytesAsUnsignedInt(bb, 4);
                if (size > 0) {
                    this.fillValue = Utils.createSubBuffer(bb, size);
                    this.fillValueDefined = true;
                } else {
                    this.fillValue = null;
                    this.fillValueDefined = false;
                }
            } else {
                this.fillValue = null;
                this.fillValueDefined = false;
            }
        } else if (version == 3) {
            BitSet flags = BitSet.valueOf(new byte[]{bb.get()});
            this.spaceAllocationTime = Utils.bitsToInt(flags, 0, 2);
            this.fillValueWriteTime = Utils.bitsToInt(flags, 2, 2);
            this.fillValueDefined = flags.get(5);
            if (this.fillValueDefined) {
                int size = Utils.readBytesAsUnsignedInt(bb, 4);
                this.fillValue = Utils.createSubBuffer(bb, size);
            } else {
                this.fillValue = null;
            }
        } else {
            throw new HdfException("Unrecognized version = " + version);
        }
    }

    public boolean isFillValueDefined() {
        return this.fillValueDefined;
    }

    public int getSpaceAllocationTime() {
        return this.spaceAllocationTime;
    }

    public int getFillValueWriteTime() {
        return this.fillValueWriteTime;
    }

    public ByteBuffer getFillValue() {
        return this.fillValue.asReadOnlyBuffer();
    }
}

