/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.pcapdecoder.structure.options.impl;

import fr.bmartel.pcapdecoder.constant.LinkLayerError;
import fr.bmartel.pcapdecoder.constant.PacketBoundState;
import fr.bmartel.pcapdecoder.constant.PacketHashType;
import fr.bmartel.pcapdecoder.constant.PacketReceptionType;
import fr.bmartel.pcapdecoder.structure.options.abstr.OptionsAbstr;
import fr.bmartel.pcapdecoder.structure.options.inter.IOptions;
import fr.bmartel.pcapdecoder.structure.options.object.OptionEnhancedPacketHeaderObject;
import fr.bmartel.pcapdecoder.utils.UtilFunctions;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class OptionsEnhancedHeader
extends OptionsAbstr {
    private OptionEnhancedPacketHeaderObject commonObject = null;

    public OptionsEnhancedHeader(int optionCode, byte[] data, boolean isBigEndian, IOptions currentOption) {
        super(optionCode, data, isBigEndian, currentOption);
        this.commonObject = (OptionEnhancedPacketHeaderObject)currentOption;
        this.decode();
    }

    public void decode() {
        try {
            switch (this.optionCode) {
                case 1: {
                    if (!this.isBigEndian) {
                        this.commonObject.setComment(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setComment(new String(this.data, "UTF-8"));
                    break;
                }
                case 2: {
                    if (!this.isBigEndian) {
                        this.parseLinkLayerInfo(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 4)));
                        break;
                    }
                    this.parseLinkLayerInfo(Arrays.copyOfRange(this.data, 0, 4));
                    break;
                }
                case 3: {
                    byte[] commonTemp = null;
                    commonTemp = !this.isBigEndian ? UtilFunctions.convertLeToBe(this.data) : this.data;
                    if (commonTemp[0] == 0) {
                        this.commonObject.setPacketHashType(PacketHashType.TWOS_COMPLEMENT);
                    } else if (commonTemp[1] == 1) {
                        this.commonObject.setPacketHashType(PacketHashType.XOR);
                    } else if (commonTemp[1] == 2) {
                        this.commonObject.setPacketHashType(PacketHashType.CRC32);
                    } else if (commonTemp[1] == 3) {
                        this.commonObject.setPacketHashType(PacketHashType.MD5);
                    } else if (commonTemp[1] == 4) {
                        this.commonObject.setPacketHashType(PacketHashType.SHA1);
                    } else {
                        this.commonObject.setPacketHashType(PacketHashType.UNKNOWN);
                    }
                    this.commonObject.setPacketHashBigEndian(Arrays.copyOfRange(commonTemp, 1, commonTemp.length));
                    break;
                }
                case 4: {
                    if (!this.isBigEndian) {
                        this.commonObject.setDropPacketCount(UtilFunctions.convertByteArrayToInt(UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 8))));
                        break;
                    }
                    this.commonObject.setDropPacketCount(UtilFunctions.convertByteArrayToInt(Arrays.copyOfRange(this.data, 0, 8)));
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void parseLinkLayerInfo(byte[] data) {
        byte bound = (byte)(data[data.length - 1] & 3);
        if (bound == 1) {
            this.commonObject.setPacketBound(PacketBoundState.INBOUND);
        } else if (bound == 2) {
            this.commonObject.setPacketBound(PacketBoundState.OUTBOUND);
        } else {
            this.commonObject.setPacketBound(PacketBoundState.UNKNOWN);
        }
        byte receptionType = (byte)(data[data.length - 1] & 0x1C);
        if (receptionType == 4) {
            this.commonObject.setPacketReceptionType(PacketReceptionType.UNICAST);
        } else if (receptionType == 8) {
            this.commonObject.setPacketReceptionType(PacketReceptionType.MULTICAST);
        } else if (receptionType == 12) {
            this.commonObject.setPacketReceptionType(PacketReceptionType.BROADCAST);
        } else if (receptionType == 16) {
            this.commonObject.setPacketReceptionType(PacketReceptionType.PROMISCUOUS);
        } else {
            this.commonObject.setPacketReceptionType(PacketReceptionType.UNKNOWN);
        }
        byte fcsLength = (byte)(data[data.length - 1] & 0xE0);
        if (fcsLength != 0) {
            this.commonObject.setFrameCheckSumLength(fcsLength & 0xFF);
        }
        byte errorDetectionByte = data[0];
        byte symbolError = (byte)(errorDetectionByte & 0x80);
        byte preambleError = (byte)(errorDetectionByte & 0x40);
        byte startFrameDelimiterError = (byte)(errorDetectionByte & 0x20);
        byte unalignedFrameError = (byte)(errorDetectionByte & 0x10);
        byte wrongInterFrameGapError = (byte)(errorDetectionByte & 8);
        byte packetTooShortError = (byte)(errorDetectionByte & 4);
        byte packetTooLongError = (byte)(errorDetectionByte & 2);
        byte crcError = (byte)(errorDetectionByte & 1);
        if (symbolError == 128) {
            this.commonObject.addLinkLayerError(LinkLayerError.SYMBOL_ERRROR);
        }
        if (preambleError == 64) {
            this.commonObject.addLinkLayerError(LinkLayerError.PREAMBLE_ERRO);
        }
        if (startFrameDelimiterError == 32) {
            this.commonObject.addLinkLayerError(LinkLayerError.START_FRAME_DELIMITER_ERROR);
        }
        if (unalignedFrameError == 16) {
            this.commonObject.addLinkLayerError(LinkLayerError.UNALIGNED_FRAME_ERROR);
        }
        if (wrongInterFrameGapError == 8) {
            this.commonObject.addLinkLayerError(LinkLayerError.WRONG_INTER_FRAME_GAP_ERROR);
        }
        if (packetTooShortError == 4) {
            this.commonObject.addLinkLayerError(LinkLayerError.PACKET_TOO_SHORT_ERROR);
        }
        if (packetTooLongError == 2) {
            this.commonObject.addLinkLayerError(LinkLayerError.PACKET_TOO_LONG_ERROR);
        }
        if (crcError == 1) {
            this.commonObject.addLinkLayerError(LinkLayerError.CRC_ERROR);
        }
    }
}

