/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTlsSecret
implements TlsSecret {
    protected byte[] data;

    protected AbstractTlsSecret(byte[] data) {
        this.data = data;
    }

    protected void checkAlive() {
        if (this.data == null) {
            throw new IllegalStateException("Secret has already been extracted or destroyed");
        }
    }

    protected abstract AbstractTlsCrypto getCrypto();

    public synchronized void destroy() {
        if (this.data != null) {
            Arrays.fill((byte[])this.data, (byte)0);
            this.data = null;
        }
    }

    public synchronized byte[] encrypt(TlsCertificate certificate) throws IOException {
        this.checkAlive();
        return this.getCrypto().createEncryptor(certificate).encrypt(this.data, 0, this.data.length);
    }

    public synchronized byte[] extract() {
        this.checkAlive();
        byte[] result = this.data;
        this.data = null;
        return result;
    }

    public synchronized boolean isAlive() {
        return null != this.data;
    }

    synchronized byte[] copyData() {
        return Arrays.clone((byte[])this.data);
    }
}

