/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.ConditionNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ClonedCondition {
    private final String conditionString;
    private final Set<ConditionNode> conditionSet = new HashSet<ConditionNode>();

    public ClonedCondition(ConditionNode conditionNode) {
        Preconditions.checkNotNull((Object)conditionNode, (Object)"conditionNode cannot be null");
        this.conditionString = conditionNode.toString();
        this.conditionSet.add(conditionNode);
    }

    public boolean containsEqual(ConditionNode checkNode) {
        return this.conditionString.equals(checkNode.toString());
    }

    public boolean addIfContainsEqual(ConditionNode newNode) {
        if (this.containsEqual(newNode)) {
            this.conditionSet.add(newNode);
            return true;
        }
        return false;
    }

    public boolean contains(ConditionNode conditionNode) {
        return this.conditionSet.contains(conditionNode);
    }

    public boolean isEquivalent(ConditionNode conditionNode) {
        ConditionNode setNode;
        String setString;
        String conditionString = conditionNode.toString();
        Iterator<ConditionNode> iterator = this.conditionSet.iterator();
        return iterator.hasNext() && conditionString.equals(setString = (setNode = iterator.next()).toString());
    }

    public void add(ConditionNode conditionNode) {
        Preconditions.checkArgument((boolean)this.containsEqual(conditionNode));
        this.conditionSet.add(conditionNode);
    }

    public String toString() {
        return this.conditionSet.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClonedCondition)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ClonedCondition other = (ClonedCondition)o;
        if (!this.conditionString.equals(other.conditionString)) {
            return false;
        }
        return this.conditionSet.equals(other.conditionSet);
    }
}

