/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHeadersFilter
implements Filter {
    public static final String HEADERS = "jetty.custom.headers.file.location";
    private final Properties properties = new Properties();
    private static final Logger LOG = LoggerFactory.getLogger(CustomHeadersFilter.class);

    public void init(FilterConfig filterConfig) {
        File headers;
        String pathToHeaders = "";
        if (filterConfig != null) {
            pathToHeaders = filterConfig.getInitParameter(HEADERS);
        }
        if (pathToHeaders != null && !pathToHeaders.isEmpty() && (headers = new File(pathToHeaders)).exists()) {
            this.loadFromFile(headers);
            LOG.info(String.format("Loaded headers from file: %s", headers.getAbsolutePath()));
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        Set<String> keys = this.properties.stringPropertyNames();
        for (String key : keys) {
            httpResponse.addHeader(key, this.properties.getProperty(key));
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    private void loadFromFile(File headers) {
        try {
            this.properties.loadFromXML(new FileInputStream(headers));
        }
        catch (IOException e) {
            LOG.error(e.toString());
        }
    }
}

