/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.jdbc.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.ddl.SqlDdlParserImpl;
import org.apache.calcite.sql.util.SqlBuilder;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDDLQueryUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcDDLQueryUtils.class);

    public static String cleanDDLQuery(String query, SqlDialect dialect) {
        SqlParser.Config sqlParserConfig = SqlParser.configBuilder().setParserFactory(SqlDdlParserImpl.FACTORY).setConformance((SqlConformance)SqlConformanceEnum.STRICT_2003).setCaseSensitive(true).setLex(Lex.MYSQL).build();
        try {
            SqlNode node = SqlParser.create((String)query, (SqlParser.Config)sqlParserConfig).parseQuery();
            return node.toSqlString(dialect).getSql();
        }
        catch (SqlParseException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static String addBackTicksToTable(String inputTable) {
        String[] queryParts = inputTable.split("\\.");
        StringBuilder cleanQuery = new StringBuilder();
        int counter = 0;
        for (String part : queryParts) {
            if (counter > 0) {
                cleanQuery.append(".");
            }
            if (part.startsWith("`") && part.endsWith("`")) {
                cleanQuery.append(part);
            } else {
                cleanQuery.append("`").append(part).append("`");
            }
            ++counter;
        }
        return cleanQuery.toString();
    }

    public static void addTableToInsertQuery(SqlBuilder builder, String rawEscapedTables) {
        String TABLE_REGEX = "(?:`(.+?)`)+";
        Pattern pattern = Pattern.compile("(?:`(.+?)`)+");
        Matcher matcher = pattern.matcher(rawEscapedTables);
        int matchCount = 0;
        while (matcher.find()) {
            if (matchCount > 0) {
                builder.append(".");
            }
            builder.identifier(matcher.group(1));
            ++matchCount;
        }
    }

    public static String addBackTicksToField(String field) {
        if (field.startsWith("`") && field.endsWith("`")) {
            return field;
        }
        StringBuilder cleanField = new StringBuilder();
        return cleanField.append("`").append(field).append("`").toString();
    }
}

