/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Tested;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedClassInstantiations;
import mockit.internal.injection.TestedObject;
import mockit.internal.injection.TestedParameter;
import mockit.internal.state.TestRun;
import mockit.internal.util.TestMethod;

public final class TestedParameters {
    @Nonnull
    private final TestMethod testMethod;
    @Nonnull
    private final InjectionState injectionState;

    public TestedParameters(@Nonnull TestMethod testMethod) {
        this.testMethod = testMethod;
        TestedClassInstantiations testedClasses = TestRun.getTestedClassInstantiations();
        this.injectionState = testedClasses == null ? new InjectionState() : testedClasses.injectionState;
    }

    public void createTestedParameters(@Nonnull Object testClassInstance, @Nonnull List<? extends InjectionProvider> injectables) {
        this.injectionState.addInjectables(testClassInstance, injectables);
        int n = this.testMethod.getParameterCount();
        for (int i = 0; i < n; ++i) {
            TestedParameter testedParameter = this.createTestedParameterIfApplicable(i);
            if (testedParameter == null) continue;
            this.instantiateTestedObject(testClassInstance, testedParameter);
        }
    }

    @Nullable
    private TestedParameter createTestedParameterIfApplicable(@Nonnegative int parameterIndex) {
        Annotation[] parameterAnnotations;
        for (Annotation parameterAnnotation : parameterAnnotations = this.testMethod.getParameterAnnotations(parameterIndex)) {
            Tested testedMetadata = TestedObject.getTestedAnnotationIfPresent(parameterAnnotation);
            if (testedMetadata == null) continue;
            return new TestedParameter(this.injectionState, this.testMethod, parameterIndex, testedMetadata);
        }
        return null;
    }

    private void instantiateTestedObject(@Nonnull Object testClassInstance, @Nonnull TestedParameter testedObject) {
        try {
            testedObject.instantiateWithInjectableValues(testClassInstance);
        }
        finally {
            this.injectionState.injectionProviders.resetConsumedInjectionProviders();
        }
    }
}

