/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionProvider;
import mockit.internal.injection.LifecycleMethods;
import mockit.internal.injection.MultiValuedProvider;
import mockit.internal.injection.TestedClass;
import mockit.internal.reflection.GenericTypeReflection;
import mockit.internal.util.Utilities;

public final class InjectionProviders {
    @Nonnull
    private List<InjectionProvider> injectables = Collections.emptyList();
    @Nonnull
    private List<InjectionProvider> consumedInjectionProviders = new ArrayList<InjectionProvider>();
    private Type typeOfInjectionPoint;

    InjectionProviders(@Nonnull LifecycleMethods lifecycleMethods) {
    }

    boolean setInjectables(@Nonnull List<? extends InjectionProvider> injectables) {
        if (injectables.isEmpty()) {
            this.injectables = Collections.emptyList();
            return false;
        }
        this.injectables = new ArrayList<InjectionProvider>(injectables);
        return true;
    }

    @Nonnull
    List<InjectionProvider> addInjectables(@Nonnull List<? extends InjectionProvider> injectablesToAdd) {
        if (!injectablesToAdd.isEmpty()) {
            if (this.injectables.isEmpty()) {
                this.injectables = new ArrayList<InjectionProvider>(injectablesToAdd);
            } else {
                this.injectables.addAll(injectablesToAdd);
            }
        }
        return this.injectables;
    }

    public void setTypeOfInjectionPoint(@Nonnull Type typeOfInjectionPoint) {
        this.typeOfInjectionPoint = typeOfInjectionPoint;
    }

    @Nullable
    public InjectionProvider getProviderByTypeAndOptionallyName(@Nonnull String nameOfInjectionPoint, @Nonnull TestedClass testedClass) {
        Type elementTypeOfIterable = InjectionProviders.getElementTypeIfIterable(this.typeOfInjectionPoint);
        if (elementTypeOfIterable != null) {
            return this.findInjectablesByTypeOnly(elementTypeOfIterable, testedClass);
        }
        return this.findInjectableByTypeAndOptionallyName(nameOfInjectionPoint, testedClass);
    }

    @Nullable
    private static Type getElementTypeIfIterable(@Nonnull Type injectableType) {
        ParameterizedType parameterizedType;
        Class classOfInjectionPoint;
        if (injectableType instanceof ParameterizedType && Iterable.class.isAssignableFrom(classOfInjectionPoint = (Class)(parameterizedType = (ParameterizedType)injectableType).getRawType())) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    @Nullable
    public InjectionProvider findNextInjectableForInjectionPoint(@Nonnull TestedClass testedClass) {
        for (InjectionProvider injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable, testedClass) || this.consumedInjectionProviders.contains(injectable)) continue;
            return injectable;
        }
        return null;
    }

    private boolean hasTypeAssignableToInjectionPoint(@Nonnull InjectionProvider injectable, @Nonnull TestedClass testedClass) {
        Type declaredType = injectable.getDeclaredType();
        return this.isAssignableToInjectionPoint(declaredType, testedClass);
    }

    boolean isAssignableToInjectionPoint(@Nonnull Type injectableType, @Nonnull TestedClass testedClass) {
        ParameterizedType parameterizedType;
        Class classOfInjectionPoint;
        if (testedClass.reflection.areMatchingTypes(this.typeOfInjectionPoint, injectableType)) {
            return true;
        }
        if (this.typeOfInjectionPoint instanceof ParameterizedType && (Iterable.class.isAssignableFrom(classOfInjectionPoint = (Class)(parameterizedType = (ParameterizedType)this.typeOfInjectionPoint).getRawType()) || InjectionPoint.INJECT_CLASS != null && Provider.class.isAssignableFrom(classOfInjectionPoint))) {
            Type providedType = parameterizedType.getActualTypeArguments()[0];
            if (providedType.equals(injectableType)) {
                return true;
            }
            Class<?> injectableClass = Utilities.getClassType(injectableType);
            Class<?> providedClass = Utilities.getClassType(providedType);
            return providedClass.isAssignableFrom(injectableClass);
        }
        return false;
    }

    @Nullable
    private InjectionProvider findInjectablesByTypeOnly(@Nonnull Type elementType, @Nonnull TestedClass testedClass) {
        GenericTypeReflection typeReflection = testedClass.reflection;
        MultiValuedProvider found = null;
        for (InjectionProvider injectable : this.injectables) {
            Type injectableType = injectable.getDeclaredType();
            Type elementTypeOfIterable = InjectionProviders.getElementTypeIfIterable(injectableType);
            if (elementTypeOfIterable != null && typeReflection.areMatchingTypes(elementType, elementTypeOfIterable)) {
                return injectable;
            }
            if (!this.isAssignableToInjectionPoint(injectableType, testedClass)) continue;
            if (found == null) {
                found = new MultiValuedProvider(elementType);
            }
            found.addInjectable(injectable);
        }
        return found;
    }

    @Nullable
    private InjectionProvider findInjectableByTypeAndOptionallyName(@Nonnull String nameOfInjectionPoint, @Nonnull TestedClass testedClass) {
        InjectionProvider foundInjectable = null;
        for (InjectionProvider injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable, testedClass)) continue;
            if (nameOfInjectionPoint.equals(injectable.getName())) {
                return injectable;
            }
            if (foundInjectable != null) continue;
            foundInjectable = injectable;
        }
        return foundInjectable;
    }

    @Nullable
    InjectionProvider findInjectableByTypeAndName(@Nonnull String nameOfInjectionPoint, @Nonnull TestedClass testedClass) {
        for (InjectionProvider injectable : this.injectables) {
            if (!this.hasTypeAssignableToInjectionPoint(injectable, testedClass) || !nameOfInjectionPoint.equals(injectable.getName())) continue;
            return injectable;
        }
        return null;
    }

    @Nullable
    Object getValueToInject(@Nonnull InjectionProvider injectionProvider, @Nullable Object currentTestClassInstance) {
        if (this.consumedInjectionProviders.contains(injectionProvider)) {
            return null;
        }
        Object value = injectionProvider.getValue(currentTestClassInstance);
        if (value != null) {
            this.consumedInjectionProviders.add(injectionProvider);
        }
        return value;
    }

    void resetConsumedInjectionProviders() {
        this.consumedInjectionProviders.clear();
    }

    @Nonnull
    public List<InjectionProvider> saveConsumedInjectionProviders() {
        List<InjectionProvider> previouslyConsumed = this.consumedInjectionProviders;
        this.consumedInjectionProviders = new ArrayList<InjectionProvider>();
        return previouslyConsumed;
    }

    public void restoreConsumedInjectionProviders(@Nonnull List<InjectionProvider> previouslyConsumed) {
        this.consumedInjectionProviders = previouslyConsumed;
    }
}

