/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.state;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.BaseInvocation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.expectations.state.CascadingTypes;
import mockit.internal.util.Utilities;

public final class ExecutingTest {
    @Nullable
    private RecordAndReplayExecution currentRecordAndReplay;
    @Nullable
    private RecordAndReplayExecution recordAndReplayForLastTestMethod;
    @Nonnull
    private final ThreadLocal<Boolean> shouldIgnoreMockingCallbacks = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    @Nonnull
    private final ThreadLocal<BaseInvocation> proceedingInvocation = new ThreadLocal();
    private boolean proceeding;
    @Nullable
    private ParameterTypeRedefinitions parameterTypeRedefinitions;
    @Nonnull
    private final List<Object> regularMocks = new ArrayList<Object>();
    @Nonnull
    private final List<Object> injectableMocks = new ArrayList<Object>();
    @Nonnull
    private final CascadingTypes cascadingTypes = new CascadingTypes();

    @Nonnull
    public RecordAndReplayExecution getOrCreateRecordAndReplay() {
        if (this.currentRecordAndReplay == null) {
            this.setRecordAndReplay(new RecordAndReplayExecution());
        }
        return this.currentRecordAndReplay;
    }

    @Nullable
    public RecordAndReplayExecution getPreviousRecordAndReplay() {
        RecordAndReplayExecution previous = this.currentRecordAndReplay;
        this.currentRecordAndReplay = null;
        return previous;
    }

    public void setRecordAndReplay(@Nullable RecordAndReplayExecution newRecordAndReplay) {
        this.recordAndReplayForLastTestMethod = null;
        this.currentRecordAndReplay = newRecordAndReplay;
    }

    @Nullable
    public RecordAndReplayExecution getCurrentRecordAndReplay() {
        return this.currentRecordAndReplay;
    }

    public boolean isShouldIgnoreMockingCallbacks() {
        return this.shouldIgnoreMockingCallbacks.get();
    }

    public boolean setShouldIgnoreMockingCallbacks(boolean flag) {
        boolean previousFlag = this.shouldIgnoreMockingCallbacks.get();
        this.shouldIgnoreMockingCallbacks.set(flag);
        return previousFlag;
    }

    public boolean isProceedingIntoRealImplementation() {
        boolean result = this.proceeding;
        this.proceeding = false;
        return result;
    }

    public void markAsProceedingIntoRealImplementation() {
        this.proceeding = true;
    }

    public void markAsProceedingIntoRealImplementation(@Nonnull BaseInvocation invocation) {
        BaseInvocation previousInvocation = this.proceedingInvocation.get();
        if (previousInvocation != null) {
            invocation.setPrevious(previousInvocation);
        }
        this.proceedingInvocation.set(invocation);
        this.proceeding = true;
    }

    public boolean shouldProceedIntoRealImplementation(@Nullable Object mock, @Nonnull String classDesc) {
        BaseInvocation pendingInvocation = this.proceedingInvocation.get();
        if (pendingInvocation != null && pendingInvocation.isMethodInSuperclass(mock, classDesc)) {
            return true;
        }
        return this.isProceedingIntoRealImplementation();
    }

    public void clearProceedingState() {
        BaseInvocation pendingInvocation = this.proceedingInvocation.get();
        BaseInvocation previousInvocation = pendingInvocation.getPrevious();
        this.proceedingInvocation.set(previousInvocation);
    }

    @Nonnull
    public RecordAndReplayExecution getRecordAndReplayForVerifications() {
        if (this.currentRecordAndReplay == null) {
            this.currentRecordAndReplay = this.recordAndReplayForLastTestMethod != null ? this.recordAndReplayForLastTestMethod : new RecordAndReplayExecution();
        }
        RecordAndReplayExecution.TEST_ONLY_PHASE_LOCK.lock();
        return this.currentRecordAndReplay;
    }

    @Nullable
    public ParameterTypeRedefinitions getParameterRedefinitions() {
        return this.parameterTypeRedefinitions;
    }

    public void setParameterRedefinitions(@Nonnull ParameterTypeRedefinitions redefinitions) {
        this.parameterTypeRedefinitions = redefinitions;
    }

    public void clearRegularAndInjectableMocks() {
        this.regularMocks.clear();
        this.injectableMocks.clear();
    }

    void addInjectableMock(@Nonnull Object mock) {
        if (!this.isInjectableMock(mock)) {
            this.injectableMocks.add(mock);
        }
    }

    public boolean isSingleInstanceOfMockedClass(@Nonnull Object mockedInstance) {
        Class<?> mockedClass = mockedInstance.getClass();
        boolean found = false;
        int n = this.regularMocks.size();
        for (int i = 0; i < n; ++i) {
            if (this.regularMocks.get(i).getClass() != mockedClass) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return found;
    }

    public boolean isInjectableMock(@Nonnull Object instance) {
        return Utilities.containsReference(this.injectableMocks, instance);
    }

    public boolean isUnmockedInstance(@Nonnull Object instance) {
        return !Utilities.containsReference(this.regularMocks, instance) && !this.isInjectableMock(instance);
    }

    public static boolean isInstanceMethodWithStandardBehavior(@Nullable Object mock, @Nonnull String nameAndDesc) {
        return mock != null && nameAndDesc.charAt(0) != '<' && ("equals(Ljava/lang/Object;)Z hashCode()I toString()Ljava/lang/String;".contains(nameAndDesc) || mock instanceof Comparable && nameAndDesc.startsWith("compareTo(L") && nameAndDesc.endsWith(";)I"));
    }

    public void registerMock(@Nonnull MockedType mockedType, @Nonnull Object mock) {
        if (mockedType.injectable) {
            this.addInjectableMock(mock);
        } else if (!Utilities.containsReference(this.regularMocks, mock)) {
            this.regularMocks.add(mock);
        }
        Type declaredType = mockedType.getDeclaredType();
        this.cascadingTypes.addInstance(declaredType, mock);
    }

    @Nonnull
    public CascadingTypes getCascadingTypes() {
        return this.cascadingTypes;
    }

    public void finishExecution() {
        this.recordAndReplayForLastTestMethod = this.currentRecordAndReplay;
        this.currentRecordAndReplay = null;
        if (this.parameterTypeRedefinitions != null) {
            this.parameterTypeRedefinitions.cleanUp();
            this.parameterTypeRedefinitions = null;
        }
        this.cascadingTypes.clearNonSharedCascadingTypes();
    }
}

