/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.instrument.ClassDefinition;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassVisitor;
import mockit.internal.ClassFile;
import mockit.internal.classGeneration.ImplementationClass;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.expectations.mocking.InterfaceImplementationGenerator;
import mockit.internal.expectations.mocking.MockedClassModifier;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.SubclassGenerationModifier;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.reflection.EmptyProxy;
import mockit.internal.state.TestRun;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.GeneratedClasses;
import mockit.internal.util.Utilities;
import mockit.internal.util.VisitInterruptedException;

class BaseTypeRedefinition {
    private static final ClassDefinition[] CLASS_DEFINITIONS = new ClassDefinition[0];
    @Nonnull
    private static final Map<Integer, MockedClass> mockedClasses = new HashMap<Integer, MockedClass>();
    @Nonnull
    private static final Map<Type, Class<?>> mockImplementations = new HashMap();
    Class<?> targetClass;
    @Nullable
    MockedType typeMetadata;
    @Nullable
    private InstanceFactory instanceFactory;
    @Nullable
    private List<ClassDefinition> mockedClassDefinitions;

    BaseTypeRedefinition() {
    }

    BaseTypeRedefinition(@Nonnull MockedType typeMetadata) {
        this.targetClass = typeMetadata.getClassType();
        this.typeMetadata = typeMetadata;
    }

    @Nullable
    final InstanceFactory redefineType(@Nonnull Type typeToMock) {
        if (this.targetClass == TypeVariable.class || this.targetClass.isInterface()) {
            this.createMockedInterfaceImplementationAndInstanceFactory(typeToMock);
        } else {
            TestRun.ensureThatClassIsInitialized(this.targetClass);
            this.redefineTargetClassAndCreateInstanceFactory(typeToMock);
        }
        if (this.instanceFactory != null) {
            Class<?> mockedType = Utilities.getClassType(typeToMock);
            TestRun.mockFixture().registerInstanceFactoryForMockedType(mockedType, this.instanceFactory);
        }
        return this.instanceFactory;
    }

    private void createMockedInterfaceImplementationAndInstanceFactory(@Nonnull Type interfaceToMock) {
        Class<?> mockedInterface = BaseTypeRedefinition.interfaceToMock(interfaceToMock);
        Object mockedInstance = mockedInterface == null ? this.createMockInterfaceImplementationUsingStandardProxy(interfaceToMock) : this.createMockInterfaceImplementationDirectly(interfaceToMock);
        this.redefinedImplementedInterfacesIfRunningOnJava8(this.targetClass);
        this.instanceFactory = new InstanceFactory.InterfaceInstanceFactory(mockedInstance);
    }

    @Nullable
    private static Class<?> interfaceToMock(@Nonnull Type typeToMock) {
        while (true) {
            if (typeToMock instanceof Class) {
                Class theInterface = (Class)typeToMock;
                if (!Modifier.isPublic(theInterface.getModifiers()) || theInterface.isAnnotation()) break;
                return theInterface;
            }
            if (!(typeToMock instanceof ParameterizedType)) break;
            typeToMock = ((ParameterizedType)typeToMock).getRawType();
        }
        return null;
    }

    @Nonnull
    private Object createMockInterfaceImplementationUsingStandardProxy(@Nonnull Type typeToMock) {
        ClassLoader loader = this.getClass().getClassLoader();
        Object mockedInstance = EmptyProxy.Impl.newEmptyProxy(loader, typeToMock);
        this.targetClass = mockedInstance.getClass();
        this.redefineClass(this.targetClass);
        return mockedInstance;
    }

    @Nonnull
    private Object createMockInterfaceImplementationDirectly(@Nonnull Type interfaceToMock) {
        Class<?> previousMockImplementationClass = mockImplementations.get(interfaceToMock);
        if (previousMockImplementationClass == null) {
            this.generateNewMockImplementationClassForInterface(interfaceToMock);
            mockImplementations.put(interfaceToMock, this.targetClass);
        } else {
            this.targetClass = previousMockImplementationClass;
        }
        return ConstructorReflection.newInstanceUsingDefaultConstructor(this.targetClass);
    }

    private void redefineClass(@Nonnull Class<?> realClass) {
        ClassReader classReader = ClassFile.createReaderOrGetFromCache(realClass);
        if (realClass.isInterface() && classReader.getVersion() < 52) {
            return;
        }
        ClassLoader loader = realClass.getClassLoader();
        MockedClassModifier modifier = this.createClassModifier(loader, classReader);
        this.redefineClass(realClass, classReader, modifier);
    }

    @Nonnull
    private MockedClassModifier createClassModifier(@Nullable ClassLoader loader, @Nonnull ClassReader classReader) {
        MockedClassModifier modifier = new MockedClassModifier(loader, classReader, this.typeMetadata);
        this.configureClassModifier(modifier);
        return modifier;
    }

    void configureClassModifier(@Nonnull MockedClassModifier modifier) {
    }

    private void generateNewMockImplementationClassForInterface(final @Nonnull Type interfaceToMock) {
        ImplementationClass implementationGenerator = new ImplementationClass(interfaceToMock){

            @Override
            @Nonnull
            protected ClassVisitor createMethodBodyGenerator(@Nonnull ClassReader cr) {
                return new InterfaceImplementationGenerator(cr, interfaceToMock, this.generatedClassName);
            }
        };
        this.targetClass = implementationGenerator.generateClass();
    }

    private void redefinedImplementedInterfacesIfRunningOnJava8(@Nonnull Class<?> aClass) {
        if (Utilities.JAVA8) {
            this.redefineImplementedInterfaces(aClass.getInterfaces());
        }
    }

    final boolean redefineMethodsAndConstructorsInTargetType() {
        return this.redefineClassAndItsSuperClasses(this.targetClass);
    }

    private boolean redefineClassAndItsSuperClasses(@Nonnull Class<?> realClass) {
        ClassLoader loader = realClass.getClassLoader();
        ClassReader classReader = ClassFile.createReaderOrGetFromCache(realClass);
        MockedClassModifier modifier = this.createClassModifier(loader, classReader);
        try {
            this.redefineClass(realClass, classReader, modifier);
        }
        catch (VisitInterruptedException ignore) {
            return false;
        }
        this.redefineElementSubclassesOfEnumTypeIfAny(modifier.enumSubclasses);
        this.redefinedImplementedInterfacesIfRunningOnJava8(realClass);
        Class<?> superClass = realClass.getSuperclass();
        boolean redefined = true;
        if (superClass != null && superClass != Object.class && superClass != Proxy.class && superClass != Enum.class) {
            redefined = this.redefineClassAndItsSuperClasses(superClass);
        }
        return redefined;
    }

    private void redefineClass(@Nonnull Class<?> realClass, @Nonnull ClassReader classReader, @Nonnull MockedClassModifier modifier) {
        classReader.accept(modifier);
        if (modifier.wasModified()) {
            byte[] modifiedClass = modifier.toByteArray();
            this.applyClassRedefinition(realClass, modifiedClass);
        }
    }

    void applyClassRedefinition(@Nonnull Class<?> realClass, @Nonnull byte[] modifiedClass) {
        ClassDefinition classDefinition = new ClassDefinition(realClass, modifiedClass);
        TestRun.mockFixture().redefineClasses(classDefinition);
        if (this.mockedClassDefinitions != null) {
            this.mockedClassDefinitions.add(classDefinition);
        }
    }

    private void redefineElementSubclassesOfEnumTypeIfAny(@Nullable List<String> enumSubclasses) {
        if (enumSubclasses != null) {
            for (String enumSubclassDesc : enumSubclasses) {
                Class enumSubclass = ClassLoad.loadByInternalName(enumSubclassDesc);
                this.redefineClass(enumSubclass);
            }
        }
    }

    private void redefineImplementedInterfaces(@Nonnull Class<?>[] implementedInterfaces) {
        for (Class<?> implementedInterface : implementedInterfaces) {
            this.redefineClass(implementedInterface);
            this.redefineImplementedInterfaces(implementedInterface.getInterfaces());
        }
    }

    private void redefineTargetClassAndCreateInstanceFactory(@Nonnull Type typeToMock) {
        Integer mockedClassId = this.redefineClassesFromCache();
        if (mockedClassId == null) {
            return;
        }
        boolean redefined = this.redefineMethodsAndConstructorsInTargetType();
        this.instanceFactory = this.createInstanceFactory(typeToMock);
        if (redefined) {
            this.storeRedefinedClassesInCache(mockedClassId);
        }
    }

    @Nonnull
    protected final InstanceFactory createInstanceFactory(@Nonnull Type typeToMock) {
        Class<?> classToInstantiate = this.targetClass;
        if (Modifier.isAbstract(classToInstantiate.getModifiers())) {
            classToInstantiate = this.generateConcreteSubclassForAbstractType(typeToMock);
        }
        return new InstanceFactory.ClassInstanceFactory(classToInstantiate);
    }

    @Nullable
    private Integer redefineClassesFromCache() {
        Integer mockedClassId = this.typeMetadata.hashCode();
        MockedClass mockedClass = mockedClasses.get(mockedClassId);
        if (mockedClass != null) {
            mockedClass.redefineClasses();
            this.instanceFactory = mockedClass.instanceFactory;
            return null;
        }
        this.mockedClassDefinitions = new ArrayList<ClassDefinition>();
        return mockedClassId;
    }

    private void storeRedefinedClassesInCache(@Nonnull Integer mockedClassId) {
        assert (this.mockedClassDefinitions != null);
        ClassDefinition[] classDefs = this.mockedClassDefinitions.toArray(CLASS_DEFINITIONS);
        MockedClass mockedClass = new MockedClass(this.instanceFactory, classDefs);
        mockedClasses.put(mockedClassId, mockedClass);
    }

    @Nonnull
    private Class<?> generateConcreteSubclassForAbstractType(final @Nonnull Type typeToMock) {
        final String subclassName = this.getNameForConcreteSubclassToCreate();
        Class subclass = new ImplementationClass<Object>(this.targetClass, subclassName){

            @Override
            @Nonnull
            protected ClassVisitor createMethodBodyGenerator(@Nonnull ClassReader cr) {
                return new SubclassGenerationModifier(BaseTypeRedefinition.this.targetClass, typeToMock, cr, subclassName, false);
            }
        }.generateClass();
        return subclass;
    }

    @Nonnull
    private String getNameForConcreteSubclassToCreate() {
        String mockId = this.typeMetadata == null ? null : this.typeMetadata.getName();
        return GeneratedClasses.getNameForGeneratedClass(this.targetClass, mockId);
    }

    private static final class MockedClass {
        @Nullable
        final InstanceFactory instanceFactory;
        @Nonnull
        final ClassDefinition[] mockedClassDefinitions;

        MockedClass(@Nullable InstanceFactory instanceFactory, @Nonnull ClassDefinition[] classDefinitions) {
            this.instanceFactory = instanceFactory;
            this.mockedClassDefinitions = classDefinitions;
        }

        void redefineClasses() {
            TestRun.mockFixture().redefineClasses(this.mockedClassDefinitions);
        }
    }
}

