/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.classGeneration;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassInfo;
import mockit.asm.classes.ClassReader;
import mockit.asm.fields.FieldVisitor;
import mockit.asm.metadata.ClassMetadataReader;
import mockit.asm.methods.MethodVisitor;
import mockit.asm.types.JavaType;
import mockit.internal.BaseClassModifier;
import mockit.internal.ClassFile;
import mockit.internal.classGeneration.MockedTypeInfo;
import mockit.internal.util.TypeDescriptor;

public class BaseSubclassGenerator
extends BaseClassModifier {
    private static final int CLASS_ACCESS_MASK = 64511;
    private static final int CONSTRUCTOR_ACCESS_MASK = 5;
    @Nonnull
    Class<?> baseClass;
    @Nonnull
    private final String subclassName;
    @Nullable
    protected final MockedTypeInfo mockedTypeInfo;
    private final boolean copyConstructors;
    @Nonnull
    private final List<String> implementedMethods;
    @Nullable
    private String superClassOfSuperClass;
    private Set<String> superInterfaces;

    protected BaseSubclassGenerator(@Nonnull Class<?> baseClass, @Nonnull ClassReader cr, @Nullable Type genericMockedType, @Nonnull String subclassName, boolean copyConstructors) {
        super(cr);
        this.baseClass = baseClass;
        this.subclassName = subclassName.replace('.', '/');
        this.mockedTypeInfo = genericMockedType == null ? null : new MockedTypeInfo(genericMockedType);
        this.copyConstructors = copyConstructors;
        this.implementedMethods = new ArrayList<String>();
    }

    @Override
    public void visit(int version, int access, @Nonnull String name, @Nonnull ClassInfo additionalInfo) {
        ClassInfo subClassInfo = new ClassInfo();
        subClassInfo.superName = name;
        subClassInfo.signature = this.mockedTypeInfo == null ? additionalInfo.signature : this.mockedTypeInfo.implementationSignature;
        int subclassAccess = access & 0xFBFF | 0x10;
        super.visit(version, subclassAccess, this.subclassName, subClassInfo);
        this.superClassOfSuperClass = additionalInfo.superName;
        this.superInterfaces = new HashSet<String>();
        String[] interfaces = additionalInfo.interfaces;
        if (interfaces.length > 0) {
            this.superInterfaces.addAll(Arrays.asList(interfaces));
        }
    }

    @Override
    public final void visitInnerClass(@Nonnull String name, @Nullable String outerName, @Nullable String innerName, int access) {
    }

    @Override
    @Nullable
    public final FieldVisitor visitField(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable Object value) {
        return null;
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (this.copyConstructors && "<init>".equals(name)) {
            if ((access & 5) != 0) {
                this.generateConstructorDelegatingToSuper(desc, signature, exceptions);
            }
        } else {
            this.generateImplementationIfAbstractMethod(this.superClassName, access, name, desc, signature, exceptions);
        }
        return null;
    }

    private void generateConstructorDelegatingToSuper(@Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        this.mw = this.cw.visitMethod(1, "<init>", desc, signature, exceptions);
        this.mw.visitVarInsn(25, 0);
        int varIndex = 1;
        for (JavaType paramType : JavaType.getArgumentTypes(desc)) {
            int loadOpcode = paramType.getLoadOpcode();
            this.mw.visitVarInsn(loadOpcode, varIndex);
            ++varIndex;
        }
        this.mw.visitMethodInsn(183, this.superClassName, "<init>", desc, false);
        this.generateEmptyImplementation();
    }

    private void generateImplementationIfAbstractMethod(String className, int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        String methodNameAndDesc;
        if (!"<init>".equals(name) && !this.implementedMethods.contains(methodNameAndDesc = name + desc)) {
            if ((access & 0x400) != 0) {
                this.generateMethodImplementation(className, access, name, desc, signature, exceptions);
            }
            this.implementedMethods.add(methodNameAndDesc);
        }
    }

    protected void generateMethodImplementation(String className, int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
    }

    @Override
    public void visitEnd() {
        this.generateImplementationsForInheritedAbstractMethods(this.superClassOfSuperClass);
        while (!this.superInterfaces.isEmpty()) {
            String superInterface = this.superInterfaces.iterator().next();
            this.generateImplementationsForAbstractMethods(superInterface, false);
            this.superInterfaces.remove(superInterface);
        }
    }

    private void generateImplementationsForInheritedAbstractMethods(@Nullable String superName) {
        if (superName != null) {
            this.generateImplementationsForAbstractMethods(superName, true);
        }
    }

    private void generateImplementationsForAbstractMethods(@Nonnull String typeName, boolean abstractClass) {
        if (!"java/lang/Object".equals(typeName)) {
            byte[] typeBytecode = ClassFile.getClassFile(typeName);
            ClassMetadataReader cmr = new ClassMetadataReader(typeBytecode);
            String[] interfaces = cmr.getInterfaces();
            if (interfaces != null) {
                this.superInterfaces.addAll(Arrays.asList(interfaces));
            }
            for (ClassMetadataReader.MethodInfo method : cmr.getMethods()) {
                if (abstractClass) {
                    this.generateImplementationIfAbstractMethod(typeName, method.accessFlags, method.name, method.desc, null, null);
                    continue;
                }
                if (!method.isAbstract()) continue;
                this.generateImplementationForInterfaceMethodIfMissing(typeName, method);
            }
            if (abstractClass) {
                String superClass = cmr.getSuperClass();
                this.generateImplementationsForInheritedAbstractMethods(superClass);
            }
        }
    }

    private void generateImplementationForInterfaceMethodIfMissing(@Nonnull String typeName, @Nonnull ClassMetadataReader.MethodInfo method) {
        String name = method.name;
        String desc = method.desc;
        String methodNameAndDesc = name + desc;
        if (!this.implementedMethods.contains(methodNameAndDesc)) {
            if (!this.hasMethodImplementation(name, desc)) {
                this.generateMethodImplementation(typeName, method.accessFlags, name, desc, null, null);
            }
            this.implementedMethods.add(methodNameAndDesc);
        }
    }

    private boolean hasMethodImplementation(@Nonnull String name, @Nonnull String desc) {
        Class<?>[] paramTypes = TypeDescriptor.getParameterTypes(desc);
        try {
            Method method = this.baseClass.getMethod(name, paramTypes);
            return !method.getDeclaringClass().isInterface();
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
    }
}

