/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.lines;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.controlFlow.Label;
import mockit.coverage.CallPoint;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineSegmentData;

public final class LineCoverageData
extends LineSegmentData {
    private static final long serialVersionUID = -6233980722802474992L;
    @Nonnull
    private List<BranchCoverageData> branches = Collections.emptyList();
    private transient int segments;

    LineCoverageData() {
    }

    public int addBranchingPoint(@Nonnull Label jumpSource, @Nonnull Label jumpTarget) {
        int initialIndex = this.branches.size();
        if (initialIndex == 0) {
            this.branches = new ArrayList<BranchCoverageData>(4);
        }
        this.branches.add(new BranchCoverageData(jumpSource));
        this.branches.add(new BranchCoverageData(jumpTarget));
        return initialIndex;
    }

    void markLastSegmentAsEmpty() {
        BranchCoverageData lastBranch = this.branches.get(this.branches.size() - 1);
        lastBranch.markAsEmpty();
    }

    private boolean noBranchesYet() {
        return this.branches == Collections.emptyList();
    }

    @Nonnull
    public BranchCoverageData getBranchData(int index) {
        return this.branches.get(index);
    }

    boolean acceptsAdditionalCallPoints(int branchIndex) {
        BranchCoverageData data = this.branches.get(branchIndex);
        return data.acceptsAdditionalCallPoints();
    }

    int registerExecution(int branchIndex, @Nullable CallPoint callPoint) {
        BranchCoverageData data = this.branches.get(branchIndex);
        return data.registerExecution(callPoint);
    }

    public boolean containsBranches() {
        return !this.noBranchesYet();
    }

    @Nonnull
    public List<BranchCoverageData> getBranches() {
        return this.branches;
    }

    boolean isValidBranch(@Nonnegative int branchIndex) {
        return this.branches.get(branchIndex) != BranchCoverageData.INVALID;
    }

    @Nonnegative
    public int getNumberOfSegments() {
        int previouslyCounted = this.segments;
        if (previouslyCounted > 0) {
            return previouslyCounted;
        }
        int n = this.branches.size();
        if (n == 0) {
            return 1;
        }
        int count = 1;
        for (int targetBranchIndex = 1; targetBranchIndex < n; targetBranchIndex += 2) {
            BranchCoverageData targetBranch = this.branches.get(targetBranchIndex);
            int targetLine = targetBranch.getLine();
            if (targetLine <= 0) continue;
            BranchCoverageData sourceBranch = this.branches.get(targetBranchIndex - 1);
            int sourceLine = sourceBranch.getLine();
            if (targetLine == sourceLine) {
                ++count;
            }
            if (targetBranch.isEmpty()) continue;
            ++count;
        }
        this.segments = count;
        return count;
    }

    public int getNumberOfCoveredSegments() {
        int segmentsCovered = this.executionCount > 0 ? 1 : 0;
        int n = this.branches.size();
        if (n == 0) {
            return segmentsCovered;
        }
        for (int sourceBranchIndex = 0; sourceBranchIndex < n; sourceBranchIndex += 2) {
            int targetLine;
            BranchCoverageData sourceBranch = this.branches.get(sourceBranchIndex);
            BranchCoverageData targetBranch = this.branches.get(sourceBranchIndex + 1);
            if (sourceBranch.isCovered() && !targetBranch.isEmpty()) {
                ++segmentsCovered;
            }
            if (!targetBranch.isCovered() || (targetLine = targetBranch.getLine()) != sourceBranch.getLine()) continue;
            ++segmentsCovered;
        }
        return segmentsCovered;
    }

    public int getNumberOfBranchingSourcesAndTargets() {
        int n = this.branches.size();
        if (n == 0) {
            return 0;
        }
        int count = 0;
        for (int sourceBranchIndex = 0; sourceBranchIndex < n; sourceBranchIndex += 2) {
            BranchCoverageData sourceBranch = this.branches.get(sourceBranchIndex);
            if (!sourceBranch.isEmpty()) {
                ++count;
            }
            ++count;
        }
        return count;
    }

    public int getNumberOfCoveredBranchingSourcesAndTargets() {
        int n = this.branches.size();
        if (n == 0) {
            return 0;
        }
        int sourcesAndTargetsCovered = 0;
        for (int sourceBranchIndex = 0; sourceBranchIndex < n; sourceBranchIndex += 2) {
            int targetLine;
            BranchCoverageData sourceBranch = this.branches.get(sourceBranchIndex);
            BranchCoverageData targetBranch = this.branches.get(sourceBranchIndex + 1);
            if (sourceBranch.isCovered()) {
                ++sourcesAndTargetsCovered;
            }
            if (!targetBranch.isCovered() || (targetLine = targetBranch.getLine()) != sourceBranch.getLine()) continue;
            ++sourcesAndTargetsCovered;
        }
        return sourcesAndTargetsCovered;
    }

    void addCountsFromPreviousTestRun(@Nonnull LineCoverageData previousData) {
        this.addExecutionCountAndCallPointsFromPreviousTestRun(previousData);
        if (this.containsBranches()) {
            int n = this.branches.size();
            for (int i = 0; i < n; ++i) {
                BranchCoverageData segmentData = this.branches.get(i);
                BranchCoverageData previousSegmentData = previousData.branches.get(i);
                segmentData.addExecutionCountAndCallPointsFromPreviousTestRun(previousSegmentData);
            }
        }
    }
}

