/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.methods;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.constantPool.AttributeWriter;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.controlFlow.Label;
import mockit.asm.util.ByteVector;

final class LineNumberTableWriter
extends AttributeWriter {
    @Nonnegative
    private int lineNumberCount;
    @Nullable
    private ByteVector lineNumbers;

    LineNumberTableWriter(@Nonnull ConstantPoolGeneration cp) {
        super(cp);
    }

    void addLineNumber(@Nonnegative int line, @Nonnull Label start) {
        if (this.lineNumbers == null) {
            this.setAttribute("LineNumberTable");
            this.lineNumbers = new ByteVector();
        }
        ++this.lineNumberCount;
        this.lineNumbers.putShort(start.position);
        this.lineNumbers.putShort(line);
    }

    boolean hasLineNumbers() {
        return this.lineNumbers != null;
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.lineNumbers == null ? 0 : 8 + this.lineNumbers.getLength();
    }

    @Override
    public void put(@Nonnull ByteVector out) {
        if (this.lineNumbers != null) {
            this.put(out, 2 + this.lineNumbers.getLength());
            out.putShort(this.lineNumberCount);
            out.putByteVector(this.lineNumbers);
        }
    }
}

