/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class GroupInfoMessage
extends Message {
    private static final int LINK_PHASE_CHANGE_PRESENT = 0;
    private static final int ESTIMATED_ENTRY_INFORMATION_PRESENT = 1;
    private final int maximumCompactLinks;
    private final int minimumDenseLinks;
    private final int estimatedNumberOfEntries;
    private final int estimatedLengthOfEntryName;

    GroupInfoMessage(ByteBuffer bb, BitSet messageFlags) {
        super(messageFlags);
        byte version = bb.get();
        if (version != 0) {
            throw new HdfException("Unrecognized version " + version);
        }
        BitSet flags = BitSet.valueOf(new byte[]{bb.get()});
        if (flags.get(0)) {
            this.maximumCompactLinks = Utils.readBytesAsUnsignedInt(bb, 2);
            this.minimumDenseLinks = Utils.readBytesAsUnsignedInt(bb, 2);
        } else {
            this.maximumCompactLinks = -1;
            this.minimumDenseLinks = -1;
        }
        if (flags.get(1)) {
            this.estimatedNumberOfEntries = Utils.readBytesAsUnsignedInt(bb, 2);
            this.estimatedLengthOfEntryName = Utils.readBytesAsUnsignedInt(bb, 2);
        } else {
            this.estimatedNumberOfEntries = -1;
            this.estimatedLengthOfEntryName = -1;
        }
    }

    public int getMaximumCompactLinks() {
        return this.maximumCompactLinks;
    }

    public int getMinimumDenseLinks() {
        return this.minimumDenseLinks;
    }

    public int getEstimatedNumberOfEntries() {
        return this.estimatedNumberOfEntries;
    }

    public int getEstimatedLengthOfEntryName() {
        return this.estimatedLengthOfEntryName;
    }
}

