/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked.indexing;

import io.jhdf.dataset.chunked.Chunk;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public class ChunkImpl
implements Chunk {
    private static final BitSet NOT_FILTERED_MASK = BitSet.valueOf(new byte[4]);
    private final long address;
    private final int size;
    private final int[] chunkOffset;
    private final BitSet filterMask;

    public ChunkImpl(long address, int size, int[] chunkOffset) {
        this(address, size, chunkOffset, NOT_FILTERED_MASK);
    }

    public ChunkImpl(long address, int size, int[] chunkOffset, BitSet filterMask) {
        this.address = address;
        this.size = size;
        this.chunkOffset = ArrayUtils.clone((int[])chunkOffset);
        this.filterMask = filterMask;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public BitSet getFilterMask() {
        return this.filterMask;
    }

    @Override
    public int[] getChunkOffset() {
        return ArrayUtils.clone((int[])this.chunkOffset);
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    public String toString() {
        return "ChunkImpl{address=" + this.address + ", size=" + this.size + ", chunkOffset=" + Arrays.toString(this.chunkOffset) + ", filterMask=" + this.filterMask + '}';
    }
}

