/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree.record;

import io.jhdf.Utils;
import io.jhdf.btree.record.BTreeDatasetChunkRecord;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.DatasetInfo;
import io.jhdf.dataset.chunked.indexing.ChunkImpl;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class FilteredDatasetChunks
extends BTreeDatasetChunkRecord {
    private final Chunk chunk;

    public FilteredDatasetChunks(ByteBuffer buffer, DatasetInfo datasetInfo) {
        long address = Utils.readBytesAsUnsignedLong(buffer, 8);
        int chunkSizeBytes = buffer.limit() - 8 - 4 - datasetInfo.getDatasetDimensions().length * 8;
        int chunkSize = Utils.readBytesAsUnsignedInt(buffer, chunkSizeBytes);
        BitSet filterMask = BitSet.valueOf(new byte[]{buffer.get(), buffer.get(), buffer.get(), buffer.get()});
        int[] chunkOffset = new int[datasetInfo.getDatasetDimensions().length];
        for (int i = 0; i < chunkOffset.length; ++i) {
            chunkOffset[i] = Utils.readBytesAsUnsignedInt(buffer, 8) * datasetInfo.getChunkDimensions()[i];
        }
        this.chunk = new ChunkImpl(address, chunkSize, chunkOffset, filterMask);
    }

    @Override
    public Chunk getChunk() {
        return this.chunk;
    }
}

