/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree;

import io.jhdf.Utils;
import io.jhdf.btree.BTreeV1;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class BTreeV1Group
extends BTreeV1 {
    private BTreeV1Group(HdfBackingStorage hdfBackingStorage, long address) {
        super(hdfBackingStorage, address);
    }

    static class BTreeV1GroupNonLeafNode
    extends BTreeV1Group {
        private final List<BTreeV1> childNodes;

        BTreeV1GroupNonLeafNode(HdfBackingStorage hdfBackingStorage, long address) {
            super(hdfBackingStorage, address);
            int keyBytes = (2 * this.entriesUsed + 1) * hdfBackingStorage.getSizeOfLengths();
            int childPointerBytes = 2 * this.entriesUsed * hdfBackingStorage.getSizeOfOffsets();
            int keysAndPointersBytes = keyBytes + childPointerBytes;
            long keysAddress = address + 8L + 2L * (long)hdfBackingStorage.getSizeOfOffsets();
            ByteBuffer keysAndPointersBuffer = hdfBackingStorage.readBufferFromAddress(keysAddress, keysAndPointersBytes);
            this.childNodes = new ArrayList<BTreeV1>(this.entriesUsed);
            for (int i = 0; i < this.entriesUsed; ++i) {
                keysAndPointersBuffer.position(keysAndPointersBuffer.position() + hdfBackingStorage.getSizeOfOffsets());
                long childAddress = Utils.readBytesAsUnsignedLong(keysAndPointersBuffer, hdfBackingStorage.getSizeOfOffsets());
                this.childNodes.add(BTreeV1GroupNonLeafNode.createGroupBTree(hdfBackingStorage, childAddress));
            }
        }

        @Override
        public List<Long> getChildAddresses() {
            ArrayList<Long> childAddresses = new ArrayList<Long>();
            for (BTreeV1 child : this.childNodes) {
                childAddresses.addAll(child.getChildAddresses());
            }
            return childAddresses;
        }
    }

    static class BTreeV1GroupLeafNode
    extends BTreeV1Group {
        private final List<Long> childAddresses;

        BTreeV1GroupLeafNode(HdfBackingStorage hdfBackingStorage, long address) {
            super(hdfBackingStorage, address);
            int keyBytes = (2 * this.entriesUsed + 1) * hdfBackingStorage.getSizeOfLengths();
            int childPointerBytes = 2 * this.entriesUsed * hdfBackingStorage.getSizeOfOffsets();
            int keysAndPointersBytes = keyBytes + childPointerBytes;
            long keysAddress = address + 8L + 2L * (long)hdfBackingStorage.getSizeOfOffsets();
            ByteBuffer keysAndPointersBuffer = hdfBackingStorage.readBufferFromAddress(keysAddress, keysAndPointersBytes);
            this.childAddresses = new ArrayList<Long>(this.entriesUsed);
            for (int i = 0; i < this.entriesUsed; ++i) {
                keysAndPointersBuffer.position(keysAndPointersBuffer.position() + hdfBackingStorage.getSizeOfLengths());
                this.childAddresses.add(Utils.readBytesAsUnsignedLong(keysAndPointersBuffer, hdfBackingStorage.getSizeOfOffsets()));
            }
        }

        @Override
        public List<Long> getChildAddresses() {
            return this.childAddresses;
        }
    }
}

