/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg.format;

import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FormatLocationTransformer;
import org.apache.drill.exec.store.iceberg.format.IcebergMetadataFileSelection;
import org.apache.iceberg.MetadataTableType;

public class IcebergFormatLocationTransformer
implements FormatLocationTransformer {
    public static final FormatLocationTransformer INSTANCE = new IcebergFormatLocationTransformer();
    public static final String METADATA_SEPARATOR = "#";

    public boolean canTransform(String location) {
        return this.getMetadataTableType(location) != null;
    }

    private MetadataTableType getMetadataTableType(String location) {
        String metadataType = StringUtils.substringAfterLast((String)location, (String)METADATA_SEPARATOR);
        return StringUtils.isNotEmpty((CharSequence)metadataType) ? MetadataTableType.from((String)metadataType) : null;
    }

    public FileSelection transform(String location, Function<String, FileSelection> selectionFactory) {
        MetadataTableType metadataTableType = this.getMetadataTableType(location);
        FileSelection fileSelection = selectionFactory.apply(location = StringUtils.substringBeforeLast((String)location, (String)METADATA_SEPARATOR));
        return fileSelection != null ? new IcebergMetadataFileSelection(fileSelection, metadataTableType) : null;
    }
}

