/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class MonthDayDateConverter
implements TypeConverter<MonthDay, Date> {
    private static final long serialVersionUID = 8087124973147837116L;

    @Override
    public MonthDay toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        return MonthDay.from(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    @Override
    public Date toDatastoreType(MonthDay md) {
        if (md == null) {
            return null;
        }
        return new Date(Date.from(md.atYear(1900).atStartOfDay(ZoneId.systemDefault()).toInstant()).getTime());
    }
}

