/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.annotations;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.annotations.AnnotationManager;
import org.datanucleus.metadata.annotations.AnnotationReader;
import org.datanucleus.metadata.annotations.ClassAnnotationHandler;
import org.datanucleus.metadata.annotations.MemberAnnotationHandler;
import org.datanucleus.metadata.annotations.ValidationNotNullAnnotationHandler;
import org.datanucleus.metadata.annotations.ValidationSizeAnnotationHandler;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class AnnotationManagerImpl
implements AnnotationManager {
    protected final MetaDataManager metadataMgr;
    Map<String, String> annotationReaderLookup = new HashMap<String, String>();
    Map<String, AnnotationReader> annotationReaders = new HashMap<String, AnnotationReader>();
    Set<String> classAnnotationHandlerAnnotations = null;
    Map<String, ClassAnnotationHandler> classAnnotationHandlers = null;
    Set<String> memberAnnotationHandlerAnnotations = null;
    Map<String, MemberAnnotationHandler> memberAnnotationHandlers = null;

    public AnnotationManagerImpl(MetaDataManager metadataMgr) {
        int i;
        this.metadataMgr = metadataMgr;
        PluginManager pluginMgr = metadataMgr.getNucleusContext().getPluginManager();
        ConfigurationElement[] elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.annotations", (String)null, (String)null);
        if (elems != null) {
            for (i = 0; i < elems.length; ++i) {
                this.annotationReaderLookup.put(elems[i].getAttribute("annotation-class"), elems[i].getAttribute("reader"));
            }
        }
        if ((elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.class_annotation_handler", (String)null, (String)null)) != null && elems.length > 0) {
            this.classAnnotationHandlerAnnotations = new HashSet<String>(elems.length);
            this.classAnnotationHandlers = new HashMap<String, ClassAnnotationHandler>(elems.length);
            for (i = 0; i < elems.length; ++i) {
                this.classAnnotationHandlerAnnotations.add(elems[i].getAttribute("annotation-class"));
            }
        }
        this.memberAnnotationHandlerAnnotations = new HashSet<String>(2);
        this.memberAnnotationHandlers = new HashMap<String, MemberAnnotationHandler>(elems != null ? elems.length : 5);
        boolean supportJavaxValidationShortcuts = metadataMgr.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.metadata.javaxValidationShortcuts");
        if (supportJavaxValidationShortcuts) {
            this.memberAnnotationHandlerAnnotations.add("javax.validation.constraints.NotNull");
            this.memberAnnotationHandlerAnnotations.add("javax.validation.constraints.Size");
        }
        if ((elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.member_annotation_handler", (String)null, (String)null)) != null && elems.length > 0) {
            for (int i2 = 0; i2 < elems.length; ++i2) {
                this.memberAnnotationHandlerAnnotations.add(elems[i2].getAttribute("annotation-class"));
            }
        }
    }

    @Override
    public AbstractClassMetaData getMetaDataForClass(Class cls, PackageMetaData pmd, ClassLoaderResolver clr) {
        if (cls == null || cls.isAnnotation()) {
            return null;
        }
        Annotation[] annotations = cls.getAnnotations();
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        String readerClassName = null;
        block2: for (Annotation annotation : annotations) {
            Annotation[] subAnnotations;
            String reader = this.annotationReaderLookup.get(annotation.annotationType().getName());
            if (reader != null) {
                readerClassName = reader;
                break;
            }
            for (Annotation subAnnotation : subAnnotations = annotation.annotationType().getAnnotations()) {
                reader = this.annotationReaderLookup.get(subAnnotation.annotationType().getName());
                if (reader == null) continue;
                readerClassName = reader;
                continue block2;
            }
        }
        if (readerClassName == null) {
            NucleusLogger.METADATA.debug(Localiser.msg("044202", cls.getName()));
            return null;
        }
        AnnotationReader reader = this.annotationReaders.get(readerClassName);
        if (reader == null) {
            try {
                Class[] ctrArgs = new Class[]{ClassConstants.METADATA_MANAGER};
                Object[] ctrParams = new Object[]{this.metadataMgr};
                PluginManager pluginMgr = this.metadataMgr.getNucleusContext().getPluginManager();
                reader = (AnnotationReader)pluginMgr.createExecutableExtension("org.datanucleus.annotations", "reader", readerClassName, "reader", ctrArgs, ctrParams);
                this.annotationReaders.put(readerClassName, reader);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.warn(Localiser.msg("044207", cls.getName(), readerClassName));
                return null;
            }
        }
        return reader.getMetaDataForClass(cls, pmd, clr);
    }

    @Override
    public boolean getClassAnnotationHasHandler(String annotationName) {
        return this.classAnnotationHandlerAnnotations != null && this.classAnnotationHandlerAnnotations.contains(annotationName);
    }

    @Override
    public boolean getMemberAnnotationHasHandler(String annotationName) {
        return this.memberAnnotationHandlerAnnotations != null && this.memberAnnotationHandlerAnnotations.contains(annotationName);
    }

    @Override
    public ClassAnnotationHandler getHandlerForClassAnnotation(String annotationName) {
        if (this.classAnnotationHandlerAnnotations == null || !this.classAnnotationHandlerAnnotations.contains(annotationName)) {
            return null;
        }
        ClassAnnotationHandler handler = this.classAnnotationHandlers.get(annotationName);
        if (handler == null) {
            try {
                PluginManager pluginMgr = this.metadataMgr.getNucleusContext().getPluginManager();
                handler = (ClassAnnotationHandler)pluginMgr.createExecutableExtension("org.datanucleus.class_annotation_handler", "annotation-class", annotationName, "handler", null, null);
                this.classAnnotationHandlers.put(annotationName, handler);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.warn(Localiser.msg("044208", annotationName));
                return null;
            }
        }
        return handler;
    }

    @Override
    public MemberAnnotationHandler getHandlerForMemberAnnotation(String annotationName) {
        if (this.memberAnnotationHandlerAnnotations == null || !this.memberAnnotationHandlerAnnotations.contains(annotationName)) {
            return null;
        }
        MemberAnnotationHandler handler = this.memberAnnotationHandlers.get(annotationName);
        if (handler == null) {
            if (annotationName.equals("javax.validation.constraints.NotNull")) {
                handler = new ValidationNotNullAnnotationHandler();
                this.memberAnnotationHandlers.put(annotationName, handler);
            } else if (annotationName.equals("javax.validation.constraints.Size")) {
                handler = new ValidationSizeAnnotationHandler();
                this.memberAnnotationHandlers.put(annotationName, handler);
            } else {
                try {
                    PluginManager pluginMgr = this.metadataMgr.getNucleusContext().getPluginManager();
                    handler = (MemberAnnotationHandler)pluginMgr.createExecutableExtension("org.datanucleus.member_annotation_handler", "annotation-class", annotationName, "handler", null, null);
                    this.memberAnnotationHandlers.put(annotationName, handler);
                }
                catch (Exception e) {
                    NucleusLogger.METADATA.warn(Localiser.msg("044209", annotationName));
                    return null;
                }
            }
        }
        return handler;
    }
}

