/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import org.jline.reader.Expander;
import org.jline.reader.History;
import sqlline.BuiltInProperty;
import sqlline.SqlLine;

public class SqlLineExpander
implements Expander {
    private final SqlLine sqlLine;
    private Properties expandProperties = null;

    public SqlLineExpander(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    public String expandHistory(History history, String line) {
        return line;
    }

    public String expandVar(String word) {
        String expandValue;
        if (this.expandProperties != null && (expandValue = (String)this.expandProperties.get(word)) != null) {
            return expandValue;
        }
        return word;
    }

    public void reset() {
        this.expandProperties = null;
        String liveTemplatesFile = this.sqlLine.getOpts().getLiveTemplatesFile();
        if (Objects.equals(liveTemplatesFile, BuiltInProperty.LIVE_TEMPLATES.defaultValue())) {
            return;
        }
        File path = new File(liveTemplatesFile);
        if (!path.exists() || !path.isFile()) {
            this.sqlLine.error(this.sqlLine.loc("no-file", path.getAbsolutePath()));
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));){
            this.expandProperties = new Properties();
            this.expandProperties.load(reader);
        }
        catch (IOException e) {
            this.sqlLine.error(e);
        }
    }
}

