/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StaticTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Tables;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hadoop.HadoopTableOperations;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopTables
implements Tables,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopTables.class);
    private static final String METADATA_JSON = "metadata.json";
    private Configuration conf;

    public HadoopTables() {
        this(new Configuration());
    }

    public HadoopTables(Configuration conf) {
        this.conf = conf;
    }

    public Table load(String location) {
        Table result;
        Pair<String, MetadataTableType> parsedMetadataType = this.parseMetadataType(location);
        if (parsedMetadataType != null) {
            result = this.loadMetadataTable(parsedMetadataType.first(), location, parsedMetadataType.second());
        } else {
            TableOperations ops = this.newTableOps(location);
            if (ops.current() != null) {
                result = new BaseTable(ops, location);
            } else {
                throw new NoSuchTableException("Table does not exist at location: %s", new Object[]{location});
            }
        }
        LOG.info("Table location loaded: {}", (Object)result.location());
        return result;
    }

    public boolean exists(String location) {
        return this.newTableOps(location).current() != null;
    }

    private Pair<String, MetadataTableType> parseMetadataType(String location) {
        int hashIndex = location.lastIndexOf(35);
        if (hashIndex != -1 && !location.endsWith("#")) {
            String baseTable = location.substring(0, hashIndex);
            String metaTable = location.substring(hashIndex + 1);
            MetadataTableType type = MetadataTableType.from(metaTable);
            return type == null ? null : Pair.of(baseTable, type);
        }
        return null;
    }

    private Table loadMetadataTable(String location, String metadataTableName, MetadataTableType type) {
        TableOperations ops = this.newTableOps(location);
        if (ops.current() == null) {
            throw new NoSuchTableException("Table does not exist at location: %s", new Object[]{location});
        }
        return MetadataTableUtils.createMetadataTableInstance(ops, location, metadataTableName, type);
    }

    public Table create(Schema schema, PartitionSpec spec, SortOrder order, Map<String, String> properties, String location) {
        return this.buildTable(location, schema).withPartitionSpec(spec).withSortOrder(order).withProperties(properties).create();
    }

    public boolean dropTable(String location) {
        return this.dropTable(location, true);
    }

    public boolean dropTable(String location, boolean purge) {
        TableOperations ops = this.newTableOps(location);
        TableMetadata lastMetadata = null;
        if (ops.current() != null) {
            if (purge) {
                lastMetadata = ops.current();
            }
        } else {
            return false;
        }
        try {
            if (purge && lastMetadata != null) {
                CatalogUtil.dropTableData(ops.io(), lastMetadata);
            }
            Path tablePath = new Path(location);
            Util.getFs(tablePath, this.conf).delete(tablePath, true);
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete file: " + location, e);
        }
    }

    @VisibleForTesting
    TableOperations newTableOps(String location) {
        if (location.contains(METADATA_JSON)) {
            return new StaticTableOperations(location, new HadoopFileIO(this.conf));
        }
        return new HadoopTableOperations(new Path(location), new HadoopFileIO(this.conf), this.conf);
    }

    private TableMetadata tableMetadata(Schema schema, PartitionSpec spec, SortOrder order, Map<String, String> properties, String location) {
        Preconditions.checkNotNull((Object)schema, (Object)"A table schema is required");
        Object tableProps = properties == null ? ImmutableMap.of() : properties;
        PartitionSpec partitionSpec = spec == null ? PartitionSpec.unpartitioned() : spec;
        SortOrder sortOrder = order == null ? SortOrder.unsorted() : order;
        return TableMetadata.newTableMetadata(schema, partitionSpec, sortOrder, location, (Map<String, String>)tableProps);
    }

    public Transaction newCreateTableTransaction(String location, Schema schema, PartitionSpec spec, Map<String, String> properties) {
        return this.buildTable(location, schema).withPartitionSpec(spec).withProperties(properties).createTransaction();
    }

    public Transaction newReplaceTableTransaction(String location, Schema schema, PartitionSpec spec, Map<String, String> properties, boolean orCreate) {
        Catalog.TableBuilder builder = this.buildTable(location, schema).withPartitionSpec(spec).withProperties(properties);
        return orCreate ? builder.createOrReplaceTransaction() : builder.replaceTransaction();
    }

    public Catalog.TableBuilder buildTable(String location, Schema schema) {
        return new HadoopTableBuilder(location, schema);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    private class HadoopTableBuilder
    implements Catalog.TableBuilder {
        private final String location;
        private final Schema schema;
        private final ImmutableMap.Builder<String, String> propertiesBuilder = ImmutableMap.builder();
        private PartitionSpec spec = PartitionSpec.unpartitioned();
        private SortOrder sortOrder = SortOrder.unsorted();

        HadoopTableBuilder(String location, Schema schema) {
            this.location = location;
            this.schema = schema;
        }

        public Catalog.TableBuilder withPartitionSpec(PartitionSpec newSpec) {
            this.spec = newSpec != null ? newSpec : PartitionSpec.unpartitioned();
            return this;
        }

        public Catalog.TableBuilder withSortOrder(SortOrder newSortOrder) {
            this.sortOrder = newSortOrder != null ? newSortOrder : SortOrder.unsorted();
            return this;
        }

        public Catalog.TableBuilder withLocation(String newLocation) {
            Preconditions.checkArgument((newLocation == null || this.location.equals(newLocation) ? 1 : 0) != 0, (Object)String.format("Table location %s differs from the table location (%s) from the PathIdentifier", newLocation, this.location));
            return this;
        }

        public Catalog.TableBuilder withProperties(Map<String, String> properties) {
            if (properties != null) {
                this.propertiesBuilder.putAll(properties);
            }
            return this;
        }

        public Catalog.TableBuilder withProperty(String key, String value) {
            this.propertiesBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Table create() {
            TableOperations ops = HadoopTables.this.newTableOps(this.location);
            if (ops.current() != null) {
                throw new AlreadyExistsException("Table already exists at location: %s", new Object[]{this.location});
            }
            ImmutableMap properties = this.propertiesBuilder.build();
            TableMetadata metadata = HadoopTables.this.tableMetadata(this.schema, this.spec, this.sortOrder, (Map)properties, this.location);
            ops.commit(null, metadata);
            return new BaseTable(ops, this.location);
        }

        public Transaction createTransaction() {
            TableOperations ops = HadoopTables.this.newTableOps(this.location);
            if (ops.current() != null) {
                throw new AlreadyExistsException("Table already exists: %s", new Object[]{this.location});
            }
            ImmutableMap properties = this.propertiesBuilder.build();
            TableMetadata metadata = HadoopTables.this.tableMetadata(this.schema, this.spec, null, (Map)properties, this.location);
            return Transactions.createTableTransaction(this.location, ops, metadata);
        }

        public Transaction replaceTransaction() {
            return this.newReplaceTableTransaction(false);
        }

        public Transaction createOrReplaceTransaction() {
            return this.newReplaceTableTransaction(true);
        }

        private Transaction newReplaceTableTransaction(boolean orCreate) {
            TableOperations ops = HadoopTables.this.newTableOps(this.location);
            if (!orCreate && ops.current() == null) {
                throw new NoSuchTableException("No such table: %s", new Object[]{this.location});
            }
            ImmutableMap properties = this.propertiesBuilder.build();
            TableMetadata metadata = ops.current() != null ? ops.current().buildReplacement(this.schema, this.spec, this.sortOrder, this.location, (Map<String, String>)properties) : HadoopTables.this.tableMetadata(this.schema, this.spec, this.sortOrder, (Map)properties, this.location);
            if (orCreate) {
                return Transactions.createOrReplaceTableTransaction(this.location, ops, metadata);
            }
            return Transactions.replaceTableTransaction(this.location, ops, metadata);
        }
    }
}

