/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.CommitCallbackTransaction;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public class CachingCatalog
implements Catalog {
    private final Cache<TableIdentifier, Table> tableCache = Caffeine.newBuilder().softValues().build();
    private final Catalog catalog;
    private final boolean caseSensitive;

    public static Catalog wrap(Catalog catalog) {
        return CachingCatalog.wrap(catalog, true);
    }

    public static Catalog wrap(Catalog catalog, boolean caseSensitive) {
        return new CachingCatalog(catalog, caseSensitive);
    }

    private CachingCatalog(Catalog catalog, boolean caseSensitive) {
        this.catalog = catalog;
        this.caseSensitive = caseSensitive;
    }

    private TableIdentifier canonicalizeIdentifier(TableIdentifier tableIdentifier) {
        if (this.caseSensitive) {
            return tableIdentifier;
        }
        return tableIdentifier.toLowerCase();
    }

    public String name() {
        return this.catalog.name();
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        return this.catalog.listTables(namespace);
    }

    public Table loadTable(TableIdentifier ident) {
        TableIdentifier canonicalized = this.canonicalizeIdentifier(ident);
        Table cached = (Table)this.tableCache.getIfPresent((Object)canonicalized);
        if (cached != null) {
            return cached;
        }
        if (MetadataTableUtils.hasMetadataTableName(canonicalized)) {
            TableIdentifier originTableIdentifier = TableIdentifier.of((String[])canonicalized.namespace().levels());
            Table originTable = (Table)this.tableCache.get((Object)originTableIdentifier, arg_0 -> ((Catalog)this.catalog).loadTable(arg_0));
            if (originTable instanceof HasTableOperations) {
                TableOperations ops = ((HasTableOperations)originTable).operations();
                MetadataTableType type = MetadataTableType.from(canonicalized.name());
                Table metadataTable = MetadataTableUtils.createMetadataTableInstance(ops, this.catalog.name(), originTableIdentifier, canonicalized, type);
                this.tableCache.put((Object)canonicalized, (Object)metadataTable);
                return metadataTable;
            }
        }
        return (Table)this.tableCache.get((Object)canonicalized, arg_0 -> ((Catalog)this.catalog).loadTable(arg_0));
    }

    public Table createTable(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        return this.buildTable(ident, schema).withPartitionSpec(spec).withLocation(location).withProperties(properties).create();
    }

    public Transaction newCreateTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        return this.buildTable(ident, schema).withPartitionSpec(spec).withLocation(location).withProperties(properties).createTransaction();
    }

    public Transaction newReplaceTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> properties, boolean orCreate) {
        Catalog.TableBuilder builder = this.buildTable(ident, schema).withPartitionSpec(spec).withLocation(location).withProperties(properties);
        if (orCreate) {
            return builder.createOrReplaceTransaction();
        }
        return builder.replaceTransaction();
    }

    public boolean dropTable(TableIdentifier ident, boolean purge) {
        boolean dropped = this.catalog.dropTable(ident, purge);
        this.invalidate(this.canonicalizeIdentifier(ident));
        return dropped;
    }

    public void renameTable(TableIdentifier from, TableIdentifier to) {
        this.catalog.renameTable(from, to);
        this.invalidate(this.canonicalizeIdentifier(from));
    }

    private void invalidate(TableIdentifier ident) {
        this.tableCache.invalidate((Object)ident);
        this.tableCache.invalidateAll(this.metadataTableIdentifiers(ident));
    }

    private Iterable<TableIdentifier> metadataTableIdentifiers(TableIdentifier ident) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MetadataTableType type : MetadataTableType.values()) {
            builder.add((Object)TableIdentifier.parse((String)(ident + "." + type.name())));
            builder.add((Object)TableIdentifier.parse((String)(ident + "." + type.name().toLowerCase(Locale.ROOT))));
        }
        return builder.build();
    }

    public Catalog.TableBuilder buildTable(TableIdentifier identifier, Schema schema) {
        return new CachingTableBuilder(identifier, schema);
    }

    private class CachingTableBuilder
    implements Catalog.TableBuilder {
        private final TableIdentifier ident;
        private final Catalog.TableBuilder innerBuilder;

        private CachingTableBuilder(TableIdentifier identifier, Schema schema) {
            this.innerBuilder = CachingCatalog.this.catalog.buildTable(identifier, schema);
            this.ident = identifier;
        }

        public Catalog.TableBuilder withPartitionSpec(PartitionSpec spec) {
            this.innerBuilder.withPartitionSpec(spec);
            return this;
        }

        public Catalog.TableBuilder withSortOrder(SortOrder sortOrder) {
            this.innerBuilder.withSortOrder(sortOrder);
            return this;
        }

        public Catalog.TableBuilder withLocation(String location) {
            this.innerBuilder.withLocation(location);
            return this;
        }

        public Catalog.TableBuilder withProperties(Map<String, String> properties) {
            this.innerBuilder.withProperties(properties);
            return this;
        }

        public Catalog.TableBuilder withProperty(String key, String value) {
            this.innerBuilder.withProperty(key, value);
            return this;
        }

        public Table create() {
            AtomicBoolean created = new AtomicBoolean(false);
            Table table = (Table)CachingCatalog.this.tableCache.get((Object)CachingCatalog.this.canonicalizeIdentifier(this.ident), identifier -> {
                created.set(true);
                return this.innerBuilder.create();
            });
            if (!created.get()) {
                throw new AlreadyExistsException("Table already exists: %s", new Object[]{this.ident});
            }
            return table;
        }

        public Transaction createTransaction() {
            return this.innerBuilder.createTransaction();
        }

        public Transaction replaceTransaction() {
            return CommitCallbackTransaction.addCallback(this.innerBuilder.replaceTransaction(), () -> CachingCatalog.this.invalidate(CachingCatalog.this.canonicalizeIdentifier(this.ident)));
        }

        public Transaction createOrReplaceTransaction() {
            return CommitCallbackTransaction.addCallback(this.innerBuilder.createOrReplaceTransaction(), () -> CachingCatalog.this.invalidate(CachingCatalog.this.canonicalizeIdentifier(this.ident)));
        }
    }
}

