/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelExpressionHandlingHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LabelExpressionHandlingHelper.class);

    public static LabelApplicabilityStatus isNodeApplicableForApp(String node, String appLabel, RMNodeLabelsManager labelsManager) {
        if (appLabel == null) {
            return LabelApplicabilityStatus.NOT_APPLICABLE;
        }
        Optional<Map.Entry> nodeLabelsOpt = labelsManager.getNodeLabels().entrySet().stream().filter(e -> ((NodeId)e.getKey()).getHost().equals(node)).findFirst();
        if (!nodeLabelsOpt.isPresent()) {
            return LabelApplicabilityStatus.NODE_DOES_NOT_HAVE_LABEL;
        }
        Set nodeLabels = (Set)nodeLabelsOpt.get().getValue();
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            return LabelApplicabilityStatus.NODE_DOES_NOT_HAVE_LABEL;
        }
        if (nodeLabels.contains(appLabel)) {
            return LabelApplicabilityStatus.NODE_HAS_LABEL;
        }
        return LabelApplicabilityStatus.NODE_DOES_NOT_HAVE_LABEL;
    }

    public static enum LabelApplicabilityStatus {
        NOT_APPLICABLE,
        NODE_HAS_LABEL,
        NODE_DOES_NOT_HAVE_LABEL;

    }
}

