/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.parser;

import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.parser.ExprLexer;
import org.apache.drill.common.expression.parser.ExprParser;
import org.apache.drill.common.parser.ErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalExpressionParser {
    private static final Logger logger = LoggerFactory.getLogger(LogicalExpressionParser.class);

    public static LogicalExpression parse(String expr, boolean allowNoIndexArray) {
        ExprLexer lexer = new ExprLexer((CharStream)CharStreams.fromString((String)expr));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExprParser parser = new ExprParser((TokenStream)tokens);
        parser.setAllowArrayWithNoIndex(allowNoIndexArray);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ErrorListener.INSTANCE);
        ExprParser.ParseContext parseContext = parser.parse();
        logger.trace("Tokens: [{}]. Parsing details: [{}].", (Object)tokens.getText(), (Object)parseContext.toInfoString(parser));
        return parseContext.e;
    }

    public static LogicalExpression parse(String expr) {
        return LogicalExpressionParser.parse(expr, false);
    }
}

