/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.ParseException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import technology.tabula.QuickSort;
import technology.tabula.Rectangle;

public class Utils {
    private static final float EPSILON = 0.01f;
    protected static boolean useQuickSort = Utils.useCustomQuickSort();

    public static boolean within(double first, double second, double variance) {
        return second < first + variance && second > first - variance;
    }

    public static boolean overlap(double y1, double height1, double y2, double height2, double variance) {
        return Utils.within(y1, y2, variance) || y2 <= y1 && y2 >= y1 - height1 || y1 <= y2 && y1 >= y2 - height2;
    }

    public static boolean overlap(double y1, double height1, double y2, double height2) {
        return Utils.overlap(y1, height1, y2, height2, 0.1f);
    }

    public static boolean feq(double f1, double f2) {
        return Math.abs(f1 - f2) < (double)0.01f;
    }

    public static float round(double d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(Double.toString(d));
        bd = bd.setScale(decimalPlace, 4);
        return bd.floatValue();
    }

    public static Rectangle bounds(Collection<? extends Shape> shapes) {
        if (shapes.isEmpty()) {
            throw new IllegalArgumentException("shapes can't be empty");
        }
        Iterator<? extends Shape> iter = shapes.iterator();
        Rectangle rv = new Rectangle();
        rv.setRect(iter.next().getBounds2D());
        while (iter.hasNext()) {
            Rectangle2D.union(iter.next().getBounds2D(), rv, rv);
        }
        return rv;
    }

    public static List<Integer> range(final int begin, final int end) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return begin + index;
            }

            @Override
            public int size() {
                return end - begin;
            }
        };
    }

    public static boolean isNumeric(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String join(String glue, String ... s) {
        int k = s.length;
        if (k == 0) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        out.append(s[0]);
        for (int x = 1; x < k; ++x) {
            out.append(glue).append(s[x]);
        }
        return out.toString();
    }

    public static <T> List<List<T>> transpose(List<List<T>> table) {
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int N = table.get(0).size();
        for (int i = 0; i < N; ++i) {
            ArrayList<T> col = new ArrayList<T>();
            for (List<T> row : table) {
                col.add(row.get(i));
            }
            ret.add(col);
        }
        return ret;
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        if (useQuickSort) {
            QuickSort.sort(list);
        } else {
            Collections.sort(list);
        }
    }

    public static <T> void sort(List<T> list, Comparator<? super T> comparator) {
        if (useQuickSort) {
            QuickSort.sort(list, comparator);
        } else {
            Collections.sort(list, comparator);
        }
    }

    private static boolean useCustomQuickSort() {
        int javaMinorVersion;
        int javaMajorVersion;
        String numberybits = System.getProperty("java.version").split("-")[0];
        String[] versionComponents = numberybits.split("\\.");
        if (versionComponents.length >= 2) {
            javaMajorVersion = Integer.parseInt(versionComponents[0]);
            javaMinorVersion = Integer.parseInt(versionComponents[1]);
        } else {
            javaMajorVersion = 1;
            javaMinorVersion = Integer.parseInt(versionComponents[0]);
        }
        boolean is16orLess = javaMajorVersion == 1 && javaMinorVersion <= 6;
        String useLegacySort = System.getProperty("java.util.Arrays.useLegacyMergeSort");
        return !is16orLess || useLegacySort != null && useLegacySort.equals("true");
    }

    public static List<Integer> parsePagesOption(String pagesSpec) throws ParseException {
        if (pagesSpec.equals("all")) {
            return null;
        }
        ArrayList<Integer> rv = new ArrayList<Integer>();
        String[] ranges = pagesSpec.split(",");
        for (int i = 0; i < ranges.length; ++i) {
            int f;
            String[] r = ranges[i].split("-");
            if (r.length == 0 || !Utils.isNumeric(r[0]) || r.length > 1 && !Utils.isNumeric(r[1])) {
                throw new ParseException("Syntax error in page range specification");
            }
            if (r.length < 2) {
                rv.add(Integer.parseInt(r[0]));
                continue;
            }
            int t = Integer.parseInt(r[0]);
            if (t > (f = Integer.parseInt(r[1]))) {
                throw new ParseException("Syntax error in page range specification");
            }
            rv.addAll(Utils.range(t, f + 1));
        }
        Collections.sort(rv);
        return rv;
    }

    public static void snapPoints(List<? extends Line2D.Float> rulings, float xThreshold, float yThreshold) {
        HashMap<Line2D.Float, Point2D[]> linesToPoints = new HashMap<Line2D.Float, Point2D[]>();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Line2D.Float float_ : rulings) {
            Point2D point2D = float_.getP1();
            Point2D p2 = float_.getP2();
            linesToPoints.put(float_, new Point2D[]{point2D, p2});
            points.add(point2D);
            points.add(p2);
        }
        Collections.sort(points, new Comparator<Point2D>(){

            @Override
            public int compare(Point2D arg0, Point2D arg1) {
                return Double.compare(arg0.getX(), arg1.getX());
            }
        });
        ArrayList<ArrayList<Point2D>> groupedPoints = new ArrayList<ArrayList<Point2D>>();
        groupedPoints.add(new ArrayList<Point2D>(Arrays.asList((Point2D)points.get(0))));
        for (Point2D point2D : points.subList(1, points.size() - 1)) {
            List last = (List)groupedPoints.get(groupedPoints.size() - 1);
            if (Math.abs(point2D.getX() - ((Point2D)last.get(0)).getX()) < (double)xThreshold) {
                ((List)groupedPoints.get(groupedPoints.size() - 1)).add(point2D);
                continue;
            }
            groupedPoints.add(new ArrayList<Point2D>(Arrays.asList(point2D)));
        }
        for (List list : groupedPoints) {
            float avgLoc = 0.0f;
            for (Point2D p : list) {
                avgLoc = (float)((double)avgLoc + p.getX());
            }
            avgLoc /= (float)list.size();
            for (Point2D p : list) {
                p.setLocation(avgLoc, p.getY());
            }
        }
        Collections.sort(points, new Comparator<Point2D>(){

            @Override
            public int compare(Point2D arg0, Point2D arg1) {
                return Double.compare(arg0.getY(), arg1.getY());
            }
        });
        groupedPoints = new ArrayList();
        groupedPoints.add(new ArrayList<Point2D>(Arrays.asList((Point2D)points.get(0))));
        for (Point2D point2D : points.subList(1, points.size() - 1)) {
            List last = (List)groupedPoints.get(groupedPoints.size() - 1);
            if (Math.abs(point2D.getY() - ((Point2D)last.get(0)).getY()) < (double)yThreshold) {
                ((List)groupedPoints.get(groupedPoints.size() - 1)).add(point2D);
                continue;
            }
            groupedPoints.add(new ArrayList<Point2D>(Arrays.asList(point2D)));
        }
        for (List list : groupedPoints) {
            float avgLoc = 0.0f;
            for (Point2D p : list) {
                avgLoc = (float)((double)avgLoc + p.getY());
            }
            avgLoc /= (float)list.size();
            for (Point2D p : list) {
                p.setLocation(p.getX(), avgLoc);
            }
        }
        for (Map.Entry entry : linesToPoints.entrySet()) {
            Point2D[] p = (Point2D[])entry.getValue();
            ((Line2D.Float)entry.getKey()).setLine(p[0], p[1]);
        }
    }

    public static BufferedImage pageConvertToImage(PDPage page, int dpi, ImageType imageType) throws IOException {
        try (PDDocument document = new PDDocument();){
            document.addPage(page);
            PDFRenderer renderer = new PDFRenderer(document);
            document.close();
            BufferedImage bufferedImage = renderer.renderImageWithDPI(0, (float)dpi, imageType);
            return bufferedImage;
        }
    }

    public static BufferedImage pageConvertToImage(PDDocument doc, PDPage page, int dpi, ImageType imageType) throws IOException {
        PDFRenderer renderer = new PDFRenderer(doc);
        return renderer.renderImageWithDPI(doc.getPages().indexOf(page), (float)dpi, imageType);
    }
}

