/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.modularinput;

import com.splunk.modularinput.MalformedDataException;
import com.splunk.modularinput.Parameter;
import com.splunk.modularinput.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ValidationDefinition {
    private Map<String, String> metadata = new HashMap<String, String>();
    private Map<String, Parameter> parameters;
    private final String serverHostField = "server_host";
    private final String serverUriField = "server_uri";
    private final String checkpointDirField = "checkpoint_dir";
    private final String sessionKeyField = "session_key";
    private final String nameField = "name";

    ValidationDefinition() {
    }

    void setServerHost(String serverHost) {
        this.metadata.put("server_host", serverHost);
    }

    public String getServerHost() {
        return this.metadata.get("server_host");
    }

    void setServerUri(String serverUri) {
        this.metadata.put("server_uri", serverUri);
    }

    public String getServerUri() {
        return this.metadata.get("server_uri");
    }

    void setCheckpointDir(String checkpointDir) {
        this.metadata.put("checkpoint_dir", checkpointDir);
    }

    public String getCheckpointDir() {
        return this.metadata.get("checkpoint_dir");
    }

    void setSessionKey(String sessionKey) {
        this.metadata.put("session_key", sessionKey);
    }

    public String getSessionKey() {
        return this.metadata.get("session_key");
    }

    void setName(String name) {
        this.metadata.put("name", name);
    }

    public String getName() {
        return this.metadata.get("name");
    }

    public void setParameters(Collection<Parameter> parameters) {
        HashMap<String, Parameter> paramMap = new HashMap<String, Parameter>();
        for (Parameter p : parameters) {
            paramMap.put(p.getName(), p);
        }
        this.parameters = paramMap;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public static ValidationDefinition parseDefinition(InputStream stream) throws ParserConfigurationException, IOException, SAXException, MalformedDataException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = documentBuilder.parse(stream);
        ValidationDefinition definition = new ValidationDefinition();
        for (Node node = doc.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
            if (node.getNodeName().equals("item")) {
                String name = node.getAttributes().getNamedItem("name").getNodeValue();
                definition.setName(name);
                List<Parameter> parameter = Parameter.nodeToParameterList(node);
                definition.setParameters(parameter);
                continue;
            }
            definition.metadata.put(node.getNodeName(), XmlUtil.textInNode(node, "Expected a text value in element " + node.getNodeName()));
        }
        return definition;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ValidationDefinition)) {
            return false;
        }
        ValidationDefinition that = (ValidationDefinition)other;
        return this.metadata.equals(that.metadata) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        return this.metadata.hashCode() ^ (this.parameters == null ? 0 : this.parameters.hashCode());
    }
}

