/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.modularinput;

import com.splunk.modularinput.MalformedDataException;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Event {
    protected Date time = null;
    protected String data;
    protected String source = null;
    protected String sourceType = null;
    protected String index = null;
    protected String host = null;
    protected boolean done = true;
    protected boolean unbroken = true;
    protected String stanza = null;

    protected void writeFieldTo(XMLStreamWriter out, String name, String value) throws XMLStreamException {
        if (value != null) {
            out.writeStartElement(name);
            out.writeCharacters(value);
            out.writeEndElement();
        }
    }

    public void writeTo(XMLStreamWriter out) throws XMLStreamException, MalformedDataException {
        if (this.data == null) {
            throw new MalformedDataException("Events must have at least the data field set to be written to XML.");
        }
        out.writeStartElement("event");
        if (this.getStanza() != null) {
            out.writeAttribute("stanza", this.getStanza());
        }
        out.writeAttribute("unbroken", this.isUnbroken() ? "1" : "0");
        if (this.time != null) {
            this.writeFieldTo(out, "time", String.format("%.3f", (double)this.time.getTime() / 1000.0));
        }
        this.writeFieldTo(out, "source", this.getSource());
        this.writeFieldTo(out, "sourcetype", this.getSourceType());
        this.writeFieldTo(out, "index", this.getIndex());
        this.writeFieldTo(out, "host", this.getHost());
        this.writeFieldTo(out, "data", this.getData());
        if (this.isDone()) {
            out.writeStartElement("done");
            out.writeEndElement();
        }
        out.writeEndElement();
        out.writeCharacters("\r\n");
        out.flush();
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setUnbroken(boolean unbroken) {
        this.unbroken = unbroken;
    }

    public boolean isUnbroken() {
        return this.unbroken;
    }

    public String getStanza() {
        return this.stanza;
    }

    public void setStanza(String stanza) {
        this.stanza = stanza;
    }
}

