/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.AtomEntry;
import com.splunk.EntityCollection;
import com.splunk.Job;
import com.splunk.JobArgs;
import com.splunk.ResponseMessage;
import com.splunk.Service;
import com.splunk.Xml;
import java.util.Map;

public class JobCollection
extends EntityCollection<Job> {
    static String oneShotNotAllowed = String.format("Oneshot not allowed, use service oneshot search method", new Object[0]);
    static final String REST_PATH = "search/jobs";

    JobCollection(Service service) {
        super(service, REST_PATH, Job.class);
        this.refreshArgs.put("count", "0");
    }

    JobCollection(Service service, Args args) {
        super(service, REST_PATH, Job.class, args);
        this.refreshArgs.put("count", "0");
    }

    @Override
    public Job create(String query) {
        return this.create(query, (Map)null);
    }

    @Override
    public Job create(String query, Map args) {
        if (args != null && args.containsKey("exec_mode") && args.get("exec_mode").equals("oneshot")) {
            throw new RuntimeException(oneShotNotAllowed);
        }
        args = Args.create(args).add("search", query);
        ResponseMessage response = this.service.post(this.path, args);
        assert (response.getStatus() == 201);
        String sid = Xml.parse(response.getContent()).getElementsByTagName("sid").item(0).getTextContent();
        Job job = new Job(this.service, "search/jobs/" + sid);
        job.refresh();
        return job;
    }

    public Job create(String query, JobArgs args) {
        return this.create(query, (Map)args);
    }

    @Override
    public ResponseMessage list() {
        return this.service.get(this.path, this.refreshArgs);
    }

    @Override
    protected String itemKey(AtomEntry entry) {
        return (String)entry.content.get("sid");
    }
}

