/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.splunk.DataModelField;
import com.splunk.EvalDataModelCalculation;
import com.splunk.GeoIPDataModelCalculation;
import com.splunk.LookupDataModelCalculation;
import com.splunk.RegexpDataModelCalculation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class DataModelCalculation {
    private final String[] ownerLineage;
    private final String calculationID;
    private final Map<String, DataModelField> generatedFields;
    private final String comment;
    private final boolean editable;

    protected DataModelCalculation(String[] ownerLineage, String calculationID, Map<String, DataModelField> generatedFields, String comment, boolean editable) {
        this.ownerLineage = ownerLineage;
        this.calculationID = calculationID;
        this.generatedFields = generatedFields;
        this.comment = comment;
        this.editable = editable;
    }

    public String getCalculationID() {
        return this.calculationID;
    }

    public boolean containsGeneratedField(String fieldName) {
        return this.generatedFields.containsKey(fieldName);
    }

    public Collection<DataModelField> getGeneratedFields() {
        return Collections.unmodifiableCollection(this.generatedFields.values());
    }

    public DataModelField getGeneratedField(String fieldName) {
        return this.generatedFields.get(fieldName);
    }

    public String getComment() {
        return this.comment;
    }

    public String getOwner() {
        return this.ownerLineage[this.ownerLineage.length - 1];
    }

    public String[] getLineage() {
        return this.ownerLineage;
    }

    public boolean isEditable() {
        return this.editable;
    }

    static DataModelCalculation parse(JsonElement json) {
        DataModelCalculation c;
        String type = null;
        String calculationId = null;
        ArrayList<LookupDataModelCalculation.LookupFieldMapping> lookupInputs = new ArrayList<LookupDataModelCalculation.LookupFieldMapping>();
        String comment = null;
        String expression = null;
        String lookupName = null;
        String lookupField = null;
        String inputField = null;
        String[] owner = new String[]{};
        boolean editable = false;
        HashMap<String, DataModelField> outputFields = new HashMap<String, DataModelField>();
        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("calculationType")) {
                type = ((JsonElement)entry.getValue()).getAsString().toLowerCase();
                continue;
            }
            if (key.equals("calculationID")) {
                calculationId = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (key.equals("outputFields")) {
                for (JsonElement e : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    DataModelField f = DataModelField.parse((JsonElement)e.getAsJsonObject());
                    outputFields.put(f.getName(), f);
                }
                continue;
            }
            if (key.equals("lookupInputs")) {
                for (JsonElement lookupInputJsonElement : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!(lookupInputJsonElement instanceof JsonObject)) {
                        throw new RuntimeException("Expected a JSON object for lookupInput entry.");
                    }
                    JsonObject lookupInputJson = (JsonObject)lookupInputJsonElement;
                    LookupDataModelCalculation.LookupFieldMapping mapping = new LookupDataModelCalculation.LookupFieldMapping();
                    mapping.inputField = lookupInputJson.get("inputField").getAsString();
                    mapping.lookupField = lookupInputJson.get("lookupField").getAsString();
                    lookupInputs.add(mapping);
                }
                continue;
            }
            if (key.equals("inputField")) {
                inputField = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (key.equals("comment")) {
                comment = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (key.equals("expression")) {
                expression = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (key.equals("lookupName")) {
                lookupName = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (key.equals("lookupField")) {
                lookupField = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (key.equals("owner")) {
                owner = ((JsonElement)entry.getValue()).getAsString().split("\\.");
                continue;
            }
            if (!key.equals("editable")) continue;
            editable = ((JsonElement)entry.getValue()).getAsBoolean();
        }
        if (type.equals("lookup")) {
            c = new LookupDataModelCalculation(owner, calculationId, outputFields, comment, editable, lookupName, lookupInputs);
        } else if (type.equals("geoip")) {
            c = new GeoIPDataModelCalculation(owner, calculationId, outputFields, comment, editable, inputField);
        } else if (type.equals("eval")) {
            c = new EvalDataModelCalculation(owner, calculationId, outputFields, comment, editable, expression);
        } else if (type.equals("rex")) {
            c = new RegexpDataModelCalculation(owner, calculationId, outputFields, comment, editable, inputField, expression);
        } else {
            throw new IllegalStateException("Unknown calculation type: " + type);
        }
        return c;
    }
}

