/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class YarnSiteAclXmlBuilder {
    private static final String CONFIG_DEMARCATION = "  <!-- :::CAUTION::: DO NOT EDIT ANYTHING ON OR ABOVE THIS LINE -->";
    private static final String YARN_SITE_TEMPLATE_FILE = "yarn-site-acl-template.xml";
    private final String pathToYarnSiteXml;

    public YarnSiteAclXmlBuilder(String pathToYarnSiteXml) {
        this.pathToYarnSiteXml = pathToYarnSiteXml;
    }

    public String build() throws IOException {
        String currentContents;
        String string = currentContents = new File(this.pathToYarnSiteXml).exists() ? this.readStream(new FileInputStream(this.pathToYarnSiteXml)) : "";
        if (currentContents.contains(CONFIG_DEMARCATION)) {
            return currentContents.replaceAll("  <!-- :::CAUTION::: DO NOT EDIT ANYTHING ON OR ABOVE THIS LINE -->\r?\n", this.buildYarnSiteXmlFromTemplate().replaceAll("(?s)</configuration>.*", ""));
        }
        return this.buildYarnSiteXmlFromTemplate();
    }

    private String buildYarnSiteXmlFromTemplate() throws IOException {
        InputStream aclTemplateStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(YARN_SITE_TEMPLATE_FILE);
        return this.readStream(aclTemplateStream);
    }

    private String readStream(InputStream stream) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            buf.append("\n");
        }
        reader.close();
        return buf.toString();
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Usage: YarnSiteAclXmlBuilder <Full path To yarn-site.xml>");
            System.exit(1);
        }
        String newYarnSiteXml = new YarnSiteAclXmlBuilder(args[0]).build();
        System.out.println(newYarnSiteXml);
    }
}

