/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.util;

import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.zookeeper.SaslClientCallbackHandler;
import org.apache.zookeeper.server.auth.KerberosName;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;

public final class SecurityUtils {
    public static final String QUORUM_HOSTNAME_PATTERN = "_HOST";

    public static SaslClient createSaslClient(Subject subject, String servicePrincipal, String protocol, String serverName, Logger LOG, String entity, String authMech) throws SaslException {
        return SecurityUtils.createSaslClient(subject, servicePrincipal, protocol, serverName, LOG, entity, authMech, "");
    }

    public static SaslClient createSaslClient(Subject subject, String servicePrincipal, String protocol, String serverName, final Logger LOG, final String entity, final String authMech, String clusterName) throws SaslException {
        String clientPrincipalName;
        String serviceHostname;
        String serviceName;
        if (subject.getPrincipals().isEmpty()) {
            LOG.info("{} will use DIGEST-MD5 as SASL mechanism.", (Object)entity);
            String[] mechs = new String[]{"DIGEST-MD5"};
            String username = (String)subject.getPublicCredentials().toArray()[0];
            String password = (String)subject.getPrivateCredentials().toArray()[0];
            SaslClient saslClient = Sasl.createSaslClient(mechs, username, protocol, serverName, null, new SaslClientCallbackHandler(password, entity));
            return saslClient;
        }
        Object[] principals = subject.getPrincipals().toArray();
        Principal clientPrincipal = (Principal)principals[0];
        LOG.debug("SecurityUtils::createSaslClient, using authentication mechanism " + authMech);
        if (authMech.equals("GSSAPI")) {
            boolean usingNativeJgss = Boolean.getBoolean("sun.security.jgss.native");
            if (usingNativeJgss) {
                try {
                    GSSManager manager = GSSManager.getInstance();
                    Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                    GSSCredential cred = manager.createCredential(null, 0, krb5Mechanism, 1);
                    subject.getPrivateCredentials().add(cred);
                    LOG.debug("Added private credential to {} principal name: '{}'", (Object)entity, (Object)clientPrincipal);
                }
                catch (GSSException ex) {
                    LOG.warn("Cannot add private credential to subject; authentication at the server may fail", (Throwable)ex);
                }
            }
            KerberosName clientKerberosName = new KerberosName(clientPrincipal.getName());
            String serverRealm = System.getProperty("zookeeper.server.realm", clientKerberosName.getRealm());
            KerberosName serviceKerberosName = new KerberosName(servicePrincipal + "@" + serverRealm);
            serviceName = serviceKerberosName.getServiceName();
            serviceHostname = serviceKerberosName.getHostName();
            clientPrincipalName = clientKerberosName.toString();
        } else {
            serviceHostname = "default";
            serviceName = null;
            clientPrincipalName = null;
        }
        try {
            final HashMap<String, String> props = new HashMap<String, String>();
            if (!clusterName.isEmpty()) {
                props.put("ClusterName", clusterName);
            }
            SaslClient saslClient = Subject.doAs(subject, new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() throws SaslException {
                    LOG.info("{} will use " + authMech + " as SASL mechanism.", (Object)entity);
                    String[] mechs = new String[]{authMech};
                    LOG.debug("creating sasl client: {}={};service={};serviceHostname={}", new Object[]{entity, clientPrincipalName, serviceName, serviceHostname});
                    SaslClient saslClient = Sasl.createSaslClient(mechs, clientPrincipalName, serviceName, serviceHostname, props, new SaslClientCallbackHandler(null, entity));
                    return saslClient;
                }
            });
            return saslClient;
        }
        catch (Exception e) {
            LOG.error("Exception while trying to create SASL client", (Throwable)e);
            return null;
        }
    }

    public static SaslServer createSaslServer(Subject subject, String protocol, String serverName, final CallbackHandler callbackHandler, final Logger LOG, String mechOpt) {
        LOG.debug("SecurityUtils.createSaslServer: name " + serverName + " callback " + callbackHandler.getClass().getName() + " mechOpt " + mechOpt);
        if (subject != null) {
            LOG.debug("SecurityUtils.createSaslServer, non-NULL subject");
            Set<Principal> s = subject.getPrincipals();
            if (s == null) {
                LOG.debug("SecurityUtils.createSaslServer: NULL subject.getPrincipals");
            }
            if (subject.getPrincipals().size() > 0) {
                try {
                    String serviceHostname;
                    String servicePrincipalName;
                    Object[] principals = subject.getPrincipals().toArray();
                    Principal servicePrincipal = (Principal)principals[0];
                    String servicePrincipalNameAndHostname = servicePrincipal.getName();
                    int indexOf = servicePrincipalNameAndHostname.indexOf("/");
                    final String mech = mechOpt == null ? "GSSAPI" : mechOpt;
                    LOG.debug("SecurityUtils.createSaslServer: Using mech " + mech);
                    if (mech.equals("GSSAPI")) {
                        servicePrincipalName = servicePrincipalNameAndHostname.substring(0, indexOf);
                        String serviceHostnameAndKerbDomain = servicePrincipalNameAndHostname.substring(indexOf + 1, servicePrincipalNameAndHostname.length());
                        indexOf = serviceHostnameAndKerbDomain.indexOf("@");
                        serviceHostname = serviceHostnameAndKerbDomain.substring(0, indexOf);
                        LOG.debug("serviceHostname is '" + serviceHostname + "'");
                        LOG.debug("servicePrincipalName is '" + servicePrincipalName + "'");
                        LOG.debug("SASL mechanism(mech) is '" + mech + "'");
                        boolean usingNativeJgss = Boolean.getBoolean("sun.security.jgss.native");
                        if (usingNativeJgss) {
                            try {
                                GSSManager manager = GSSManager.getInstance();
                                Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                                GSSName gssName = manager.createName(servicePrincipalName + "@" + serviceHostname, GSSName.NT_HOSTBASED_SERVICE);
                                GSSCredential cred = manager.createCredential(gssName, 0, krb5Mechanism, 2);
                                subject.getPrivateCredentials().add(cred);
                                LOG.debug("Added private credential to service principal name: '{}', GSSCredential name: {}", (Object)servicePrincipalName, (Object)cred.getName());
                            }
                            catch (GSSException ex) {
                                LOG.warn("Cannot add private credential to subject; clients authentication may fail", (Throwable)ex);
                            }
                        }
                    } else {
                        serviceHostname = "default";
                        servicePrincipalName = null;
                    }
                    LOG.info("SecurityUtils.createSaslServer: SASL mechanism(mech) is " + mech + "'");
                    LOG.info("SecurityUtils.createSaslServer: SASL servicePrincipalNameAndHostname is " + servicePrincipalNameAndHostname);
                    try {
                        return Subject.doAs(subject, new PrivilegedExceptionAction<SaslServer>(){

                            @Override
                            public SaslServer run() {
                                try {
                                    SaslServer saslServer = Sasl.createSaslServer(mech, servicePrincipalName, serviceHostname, null, callbackHandler);
                                    return saslServer;
                                }
                                catch (SaslException e) {
                                    LOG.error("Zookeeper Server failed to create a SaslServer to interact with a client during session initiation: ", (Throwable)e);
                                    return null;
                                }
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        LOG.error("Zookeeper Quorum member experienced a PrivilegedActionException exception while creating a SaslServer using a JAAS principal context:", (Throwable)e);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error("server principal name/hostname determination error: ", (Throwable)e);
                }
            } else {
                try {
                    SaslServer saslServer = Sasl.createSaslServer("DIGEST-MD5", protocol, serverName, null, callbackHandler);
                    return saslServer;
                }
                catch (SaslException e) {
                    LOG.error("Zookeeper Quorum member failed to create a SaslServer to interact with a client during session initiation", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static String getServerPrincipal(String principalConfig, String hostname) {
        String[] components = SecurityUtils.getComponents(principalConfig);
        if (components == null || components.length != 2 || !components[1].equals(QUORUM_HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        return SecurityUtils.replacePattern(components, hostname);
    }

    private static String[] getComponents(String principalConfig) {
        if (principalConfig == null) {
            return null;
        }
        return principalConfig.split("[/]");
    }

    private static String replacePattern(String[] components, String hostname) {
        return components[0] + "/" + hostname.toLowerCase();
    }
}

