/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.queryserver.client;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosLoginFromTicketCache {
    public static Subject login() throws LoginException {
        KerberosConfiguration kerberosConfig = new KerberosConfiguration();
        Subject subject = new Subject();
        LoginContext lc = new LoginContext("PhoenixThinClient", subject, new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                throw new UnsupportedCallbackException(callbacks[0], "Only ticket cache is supported");
            }
        }, kerberosConfig);
        lc.login();
        return subject;
    }

    private static class KerberosConfiguration
    extends Configuration {
        private static final String IBM_KRB5_LOGIN_MODULE = "com.ibm.security.auth.module.Krb5LoginModule";
        private static final String SUN_KRB5_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
        private static final String JAVA_VENDOR_NAME = System.getProperty("java.vendor");
        private static final boolean IS_IBM_JAVA = JAVA_VENDOR_NAME.contains("IBM");

        private KerberosConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (IS_IBM_JAVA) {
                options.put("principal", System.getProperty("user.name"));
                options.put("useDefaultCcache", "true");
                return new AppConfigurationEntry[]{new AppConfigurationEntry(IBM_KRB5_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
            options.put("useTicketCache", "true");
            options.put("doNotPrompt", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(SUN_KRB5_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

