/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ojai.DocumentReader;
import org.ojai.annotation.API;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.EncodingException;
import org.ojai.exceptions.TypeException;

public class DocumentReaders {
    public static Map<String, Object> encode(@API.NonNullable DocumentReader reader) throws EncodingException, TypeException {
        try {
            DocumentReader.EventType event = reader.next();
            if (event != DocumentReader.EventType.START_MAP) {
                throw new EncodingException("Expected " + (Object)((Object)DocumentReader.EventType.START_MAP) + ", received " + (Object)((Object)event));
            }
            return DocumentReaders.encodeMap(reader);
        }
        catch (DecodingException de) {
            throw new EncodingException(de);
        }
    }

    public static Map<String, Object> encodeMap(DocumentReader dr) throws EncodingException, TypeException {
        DocumentReader.EventType event = dr.getCurrentEvent();
        if (event != DocumentReader.EventType.START_MAP) {
            throw new EncodingException("DocumentReader must be at START_MAP, found: " + (Object)((Object)event));
        }
        try {
            LinkedHashMap<String, Object> docMap = new LinkedHashMap<String, Object>();
            block8: while (true) {
                if ((event = dr.next()) == null) {
                    throw new EncodingException("EOR: malformed document.");
                }
                switch (event) {
                    case START_MAP: {
                        docMap.put(dr.getFieldName(), DocumentReaders.encodeMap(dr));
                        continue block8;
                    }
                    case END_MAP: {
                        return docMap;
                    }
                    case START_ARRAY: {
                        docMap.put(dr.getFieldName(), DocumentReaders.encodeArray(dr));
                        continue block8;
                    }
                    case END_ARRAY: {
                        throw new EncodingException("END_ARRAY was not expected in encodeMap()");
                    }
                }
                docMap.put(dr.getFieldName(), DocumentReaders.encodeValue(dr));
            }
        }
        catch (DecodingException de) {
            throw new EncodingException(de);
        }
    }

    public static List<Object> encodeArray(DocumentReader dr) throws EncodingException, TypeException {
        DocumentReader.EventType event = dr.getCurrentEvent();
        if (event != DocumentReader.EventType.START_ARRAY) {
            throw new EncodingException("DocumentReader must be at START_ARRAY, found: " + (Object)((Object)event));
        }
        ArrayList<Object> objList = new ArrayList<Object>();
        int lastIndex = -1;
        block6: while ((event = DocumentReaders.nextEvent(dr)) != DocumentReader.EventType.END_ARRAY) {
            if (event == null) {
                throw new EncodingException("Malformed document");
            }
            switch (event) {
                case END_MAP: {
                    throw new EncodingException("Unexpected event: " + (Object)((Object)event));
                }
                case END_ARRAY: {
                    return objList;
                }
                case START_MAP: {
                    lastIndex = DocumentReaders.addToArrayList(objList, DocumentReaders.encodeMap(dr), lastIndex, dr.getArrayIndex());
                    continue block6;
                }
                case START_ARRAY: {
                    lastIndex = DocumentReaders.addToArrayList(objList, DocumentReaders.encodeArray(dr), lastIndex, dr.getArrayIndex());
                    continue block6;
                }
            }
            lastIndex = DocumentReaders.addToArrayList(objList, DocumentReaders.encodeValue(dr), lastIndex, dr.getArrayIndex());
        }
        return objList;
    }

    public static Object encodeValue(DocumentReader dr) throws EncodingException, TypeException {
        DocumentReader.EventType event = dr.getCurrentEvent();
        switch (event) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return dr.getBoolean();
            }
            case STRING: {
                return dr.getString();
            }
            case BYTE: {
                return dr.getByte();
            }
            case SHORT: {
                return dr.getShort();
            }
            case INT: {
                return dr.getInt();
            }
            case LONG: {
                return dr.getLong();
            }
            case FLOAT: {
                return Float.valueOf(dr.getFloat());
            }
            case DOUBLE: {
                return dr.getDouble();
            }
            case DECIMAL: {
                return dr.getDecimal();
            }
            case DATE: {
                return dr.getDate();
            }
            case TIME: {
                return dr.getTime();
            }
            case TIMESTAMP: {
                return dr.getTimestamp();
            }
            case INTERVAL: {
                return dr.getInterval();
            }
            case BINARY: {
                return dr.getBinary().duplicate();
            }
        }
        throw new EncodingException("Unexpected event: " + (Object)((Object)event));
    }

    private static DocumentReader.EventType nextEvent(DocumentReader dr) {
        try {
            return dr.next();
        }
        catch (DecodingException de) {
            throw new EncodingException(de);
        }
    }

    private static int addToArrayList(List<Object> list, Object elem, int lastIndex, int currentIndex) {
        int nullCount = currentIndex - lastIndex;
        for (int i = 1; i <= nullCount; ++i) {
            list.add(null);
        }
        list.set(currentIndex, elem);
        return currentIndex;
    }
}

