/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.types;

import java.io.Serializable;
import org.ojai.annotation.API;

@API.Public
public final class OInterval
implements Serializable {
    private static final long serialVersionUID = 2486957803021538577L;
    private static final double APPROX_DAYS_IN_YEAR = 365.25;
    private static final double APPROX_DAYS_IN_MONTH = 30.4375;
    private final int years;
    private final int months;
    private final int days;
    private final int seconds;
    private final int milliseconds;
    private final transient long timeDuration;

    public OInterval(long milliseconds) {
        this.timeDuration = milliseconds;
        this.milliseconds = (int)(milliseconds % 1000L);
        this.seconds = (int)(milliseconds % 86400000L) / 1000;
        this.days = (int)(milliseconds / 86400000L);
        this.months = 0;
        this.years = 0;
    }

    public OInterval(String iso8601DurationPattern) {
        this(0, 0, 0, 0, 0);
    }

    public OInterval(int years, int months, int days, int seconds, int milliseconds) {
        this.years = years;
        this.months = months;
        this.days = days;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
        long totalDays = (long)((double)years * 365.25 + (double)months * 30.4375 + (double)days);
        this.timeDuration = 86400000L * totalDays + (long)(seconds * 1000) + (long)milliseconds;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public long getTimeInMillis() {
        return this.timeDuration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.timeDuration ^ this.timeDuration >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OInterval other = (OInterval)obj;
        return this.timeDuration == other.timeDuration;
    }
}

